/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.config.SvnIniFile;

public class ProxyModule
extends BaseCommandRuntimeModule {
    public ProxyModule(@NotNull CommandRuntime runtime) {
        if (runtime == null) {
            ProxyModule.$$$reportNull$$$0(0);
        }
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (command == null) {
            ProxyModule.$$$reportNull$$$0(1);
        }
        if (this.myAuthenticationService.haveDataForTmpConfig() && !CommandRuntime.isLocal(command)) {
            this.setupProxy(command);
        }
    }

    private void setupProxy(@NotNull Command command) {
        Url repositoryUrl;
        Proxy proxy;
        if (command == null) {
            ProxyModule.$$$reportNull$$$0(2);
        }
        if ((proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl = command.requireRepositoryUrl())) != null) {
            String hostGroup = this.ensureGroupForHost(command, repositoryUrl.getHost());
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-host=%s", hostGroup, address.getHostName()));
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-port=%s", hostGroup, address.getPort()));
        }
    }

    @NotNull
    private String ensureGroupForHost(@NotNull Command command, @NotNull String host) {
        SvnIniFile configFile;
        String groupName;
        if (command == null) {
            ProxyModule.$$$reportNull$$$0(3);
        }
        if (host == null) {
            ProxyModule.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)(groupName = SvnIniFile.getGroupForHost(host, configFile = new SvnIniFile(this.myAuthenticationService.getSpecialConfigDir()))))) {
            groupName = SvnIniFile.getNewGroupName(host, configFile);
            command.put("--config-option");
            command.put(String.format("servers:groups:%s=%s*", groupName, host));
        }
        String string = groupName;
        if (string == null) {
            ProxyModule.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/ProxyModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/ProxyModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureGroupForHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupProxy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureGroupForHost";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

