/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import java.rmi.RemoteException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RuntimeRemoteException;

public class TransferListenerAdapter
implements TransferListener {
    protected final MavenServerProgressIndicator myIndicator;

    public TransferListenerAdapter(MavenServerProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    private void checkCanceled() {
        try {
            if (this.myIndicator.isCanceled()) {
                throw new MavenProcessCanceledRuntimeException();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    private static String formatResourceName(TransferEvent event) {
        TransferResource resource = event.getResource();
        File file = resource.getFile();
        return (file == null ? resource.getResourceName() : file.getName()) + " [" + resource.getRepositoryUrl() + "]";
    }

    public void transferInitiated(TransferEvent event) {
        this.checkCanceled();
        try {
            String eventString = TransferListenerAdapter.formatResourceName(event);
            this.myIndicator.setIndeterminate(true);
            this.myIndicator.setText2(eventString);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.transferProgressed(event);
    }

    public void transferProgressed(TransferEvent event) {
        this.checkCanceled();
        TransferResource r = event.getResource();
        long totalLength = r.getContentLength();
        String sizeInfo = totalLength <= 0L ? StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / ?" : StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / " + StringUtilRt.formatFileSize((long)totalLength);
        try {
            this.myIndicator.setText2(TransferListenerAdapter.formatResourceName(event) + "  (" + sizeInfo + ')');
            if (totalLength <= 0L) {
                this.myIndicator.setIndeterminate(true);
            } else {
                this.myIndicator.setIndeterminate(false);
                this.myIndicator.setFraction((double)event.getTransferredBytes() / (double)totalLength);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        try {
            this.myIndicator.setText2("Checksum failed: " + TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        try {
            this.myIndicator.setText2("Finished (" + StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + ") " + TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
            Maven3ServerGlobals.getDownloadListener().artifactDownloaded(event.getResource().getFile(), event.getResource().getResourceName());
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferFailed(TransferEvent event) {
        try {
            if (this.myIndicator.isCanceled()) {
                this.myIndicator.setText2("Canceling...");
                return;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
        try {
            this.myIndicator.setText2("Failed to download " + TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }
}

