/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.view.communications;

import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RsUrlPathSpecification;
import com.intellij.ws.rest.providers.RSUrlTargetInfo;
import com.intellij.ws.rest.utils.RSUtils;
import com.intellij.ws.rest.view.communications.RSEndpointsProvider;
import icons.JavaUltimateIcons;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ws/rest/view/communications/RSServerFramework;", "Lcom/intellij/ws/rest/view/communications/RSEndpointsProvider;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "serversSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "Lcom/intellij/ws/rest/model/jam/RSJamPsiClassPath;", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "rsHttpMethod", "Lcom/intellij/ws/rest/model/jam/RSHttpMappingInfo;", "intellij.javaee.jax.rs"})
public final class RSServerFramework
extends RSEndpointsProvider {
    private final SourceTestLibSearcher<RSJamPsiClassPath> serversSearcher = new SourceTestLibSearcher("RS_SERVERS", (Function2)new Function2<Module, GlobalSearchScope, Collection<? extends RSJamPsiClassPath>>(RSJamModel.INSTANCE){

        @NotNull
        public final Collection<RSJamPsiClassPath> invoke(@NotNull Module p1, @NotNull GlobalSearchScope p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            RSJamModel cfr_ignored_0 = (RSJamModel)this.receiver;
            return RSJamModel.findServerPaths(p1, p2);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("JEE-RESTful-WS-Server", "JEE RESTful WS Server", JavaUltimateIcons.Web.RequestMapping);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public Iterable<RSJamPsiClassPath> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        Module module = ((ModuleEndpointsFilter)filter).getModule();
        if (!RSUtils.hasRestLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        return this.serversSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @Override
    @NotNull
    protected Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull RSHttpMappingInfo rsHttpMethod) {
        Intrinsics.checkNotNullParameter((Object)rsHttpMethod, (String)"rsHttpMethod");
        UrlPath urlPath = RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(rsHttpMethod));
        return CollectionsKt.listOf((Object)new RSUrlTargetInfo(UrlConstants.HTTP_SCHEMES, urlPath, rsHttpMethod, null, 8, null));
    }
}

