/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.view.communications;

import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.utils.RSUtils;
import icons.JavaUltimateIcons;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\u0003H$J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ws/rest/view/communications/RSEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/ws/rest/model/jam/RSJamPsiClassPath;", "Lcom/intellij/ws/rest/model/jam/RSHttpMappingInfo;", "()V", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "rsHttpMethod", "isValidEndpoint", "", "intellij.javaee.jax.rs"})
public abstract class RSEndpointsProvider
implements EndpointsProvider<RSJamPsiClassPath, RSHttpMappingInfo> {
    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RSUtils.hasRestLibrary(project) ? EndpointsProvider.Status.AVAILABLE : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<RSHttpMappingInfo> getEndpoints(@NotNull RSJamPsiClassPath group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiClass psiClass = (PsiClass)group.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"group.psiElement");
        return RSJamModel.getHttpMappings(psiClass);
    }

    @NotNull
    protected abstract Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull RSHttpMappingInfo var1);

    @Nullable
    public Object getEndpointData(@NotNull RSJamPsiClassPath group, @NotNull RSHttpMappingInfo endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet((Supplier)new Supplier<Iterable<? extends UrlTargetInfo>>(this, endpoint){
            final /* synthetic */ RSEndpointsProvider this$0;
            final /* synthetic */ RSHttpMappingInfo $endpoint;

            public final Iterable<UrlTargetInfo> get() {
                return this.this$0.getUrlTargetInfo(this.$endpoint);
            }
            {
                this.this$0 = rSEndpointsProvider;
                this.$endpoint = rSHttpMappingInfo;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026UrlTargetInfo(endpoint) }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)((PsiElement)endpoint.getMapping().getPsiElement()));
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull RSJamPsiClassPath group, @NotNull RSHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String string = RSUtils.getResourcePath(endpoint);
        String string2 = endpoint.getMapping().getShortAnnoName();
        PsiClass psiClass = (PsiClass)group.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"group.psiElement");
        return (ItemPresentation)new HttpMethodPresentation(string, string2, psiClass.getName(), JavaUltimateIcons.Web.RequestMapping);
    }

    public boolean isValidEndpoint(@NotNull RSJamPsiClassPath group, @NotNull RSHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

