/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.jam.JamService;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.model.jam.microprofile.MicroprofileRegisterRestClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RSUtils {
    private RSUtils() {
    }

    @NotNull
    @NlsSafe
    public static String getResourcePath(@NotNull RSHttpMethod httpMethod) {
        String resourceValue;
        RSJamPsiMethodPath methodPathResource;
        RSJamPsiClassPath psiClassPath;
        if (httpMethod == null) {
            RSUtils.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        PsiMethod psiMethod = httpMethod.getPsiElement();
        JamService service = JamService.getJamService((Project)psiMethod.getProject());
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
            buffer.append(psiClassPath.getResourceValue());
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null && (resourceValue = methodPathResource.getResourceValue()) != null) {
            if (!buffer.toString().endsWith("/") && !resourceValue.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(resourceValue);
        }
        String string = buffer.toString();
        if (string == null) {
            RSUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getResourcePath(@NotNull RSHttpMappingInfo httpMapping) {
        String resourceValue;
        PsiMethod psiMethod;
        RSJamPsiMethodPath methodPathResource;
        if (httpMapping == null) {
            RSUtils.$$$reportNull$$$0(2);
        }
        UrlMappingBuilder builder = new UrlMappingBuilder();
        RSHttpMethod mapping = httpMapping.getMapping();
        JamService service = JamService.getJamService((Project)mapping.getPsiElement().getProject());
        PsiClass containingClass = httpMapping.getHolder();
        if (containingClass != null) {
            RSJamPsiClassPath psiClassPath;
            MicroprofileRegisterRestClient registerRestClient = (MicroprofileRegisterRestClient)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{MicroprofileRegisterRestClient.META});
            if (registerRestClient != null) {
                builder.appendSegment(registerRestClient.getBaseUri());
            }
            if ((psiClassPath = (RSJamPsiClassPath)service.getJamElement((PsiElement)containingClass, new JamMemberMeta[]{RSJamPsiClassPath.META})) != null) {
                builder.appendSegment(psiClassPath.getResourceValue());
            }
        }
        if ((methodPathResource = (RSJamPsiMethodPath)service.getJamElement((PsiElement)(psiMethod = mapping.getPsiElement()), new JamMemberMeta[]{RSJamPsiMethodPath.META})) != null && (resourceValue = methodPathResource.getResourceValue()) != null) {
            builder.appendSegment(resourceValue);
        }
        return builder.buildOrNull();
    }

    public static boolean isResourceClass(@NotNull PsiClass resource) {
        if (resource == null) {
            RSUtils.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)resource, Arrays.asList(RSAnnotations.PATH.all()), (int)1);
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            RSUtils.$$$reportNull$$$0(4);
        }
        return (String)AnnotationModelUtil.getStringValue((PsiAnnotation)anno, (String)"value", null).getValue();
    }

    public static void annotateFieldWithPathParam(Project project, PsiField field, String name) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(field.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation annotation = factory.createAnnotationFromText("@" + RSAnnotations.PATH_PARAM.fqn((PsiElement)field) + "(\"" + name + "\")", (PsiElement)field);
        PsiElement firstChild = modifierList.getFirstChild();
        if (firstChild != null) {
            modifierList.addBefore((PsiElement)annotation, firstChild);
        } else {
            modifierList.add((PsiElement)annotation);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
    }

    public static boolean hasRestLibrary(Module module) {
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)RSAnnotations.PATH.javax()) || JavaLibraryUtils.hasLibraryClass((Module)module, (String)RSAnnotations.PATH.jakarta());
    }

    public static boolean hasMicroProfileClientLibrary(@NotNull Project project) {
        if (project == null) {
            RSUtils.$$$reportNull$$$0(5);
        }
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.eclipse.microprofile.rest.client.inject.RestClient");
    }

    public static boolean hasRestLibrary(@NotNull Project project) {
        if (project == null) {
            RSUtils.$$$reportNull$$$0(6);
        }
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)RSAnnotations.PATH.javax()) || JavaLibraryUtils.hasLibraryClass((Project)project, (String)RSAnnotations.PATH.jakarta());
    }

    @NotNull
    public static List<String> findPathParamNames(@NotNull PsiAnnotation annotation) {
        List list;
        if (annotation == null) {
            RSUtils.$$$reportNull$$$0(7);
        }
        String path = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)annotation, (String)"value", null).getValue();
        try {
            list = new UriTemplateParser(path).getNames();
        }
        catch (Exception ignored) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RSUtils.$$$reportNull$$$0(9);
            }
            return list2;
        }
        if (list == null) {
            RSUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMethod";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/utils/RSUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/utils/RSUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPathParamNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePath";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasMicroProfileClientLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasRestLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPathParamNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

