/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.model.jam.httpMethods;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSCustomHttpMethod
extends RSHttpMethod {
    private final String myHttpMethod;
    private static final Function<Module, Collection<String>> ANNOTATIONS = module -> RSCustomHttpMethod.getCustomHttpAnnotations(module);
    private final PsiAnchor myPsiAnchor;

    public RSCustomHttpMethod(@Nullable String httpMethod, @NotNull PsiElement psiMethod) {
        if (psiMethod == null) {
            RSCustomHttpMethod.$$$reportNull$$$0(0);
        }
        this.myHttpMethod = httpMethod;
        this.myPsiAnchor = PsiAnchor.create((PsiElement)psiMethod);
    }

    @Override
    @NotNull
    public PsiMethod getPsiElement() {
        PsiMethod psiMethod = (PsiMethod)JamCommonUtil.retrieveOrThrow((PsiAnchor)this.myPsiAnchor);
        if (psiMethod == null) {
            RSCustomHttpMethod.$$$reportNull$$$0(1);
        }
        return psiMethod;
    }

    @Override
    public boolean isValid() {
        PsiElement psiElement = this.myPsiAnchor.retrieve();
        return psiElement != null && psiElement.isValid();
    }

    @Override
    @NotNull
    public String getShortAnnoName() {
        String string = StringUtil.toUpperCase((String)this.myHttpMethod);
        if (string == null) {
            RSCustomHttpMethod.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static Collection<String> getCustomHttpAnnotations(Module module) {
        if (module == null || module.isDisposed()) {
            return Collections.emptyList();
        }
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<String> knownAnnotations = new HashSet<String>(RSAnnotations.HTTP_ANNOTATIONS);
            knownAnnotations.add(RSAnnotations.HTTP_METHOD.javax());
            knownAnnotations.add(RSAnnotations.HTTP_METHOD.jakarta());
            HashSet classes = new HashSet();
            classes.addAll(MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)RSAnnotations.HTTP_METHOD.javax(), (boolean)true));
            classes.addAll(MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)RSAnnotations.HTTP_METHOD.jakarta(), (boolean)true));
            List annotations = classes.stream().map(PsiClass::getQualifiedName).filter(x -> !knownAnnotations.contains(x)).collect(Collectors.toList());
            return CachedValueProvider.Result.create(annotations, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    @NotNull
    public static Function<Module, Collection<String>> getCustomHttpAnnotations() {
        Function<Module, Collection<String>> function = ANNOTATIONS;
        if (function == null) {
            RSCustomHttpMethod.$$$reportNull$$$0(3);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/model/jam/httpMethods/RSCustomHttpMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/model/jam/httpMethods/RSCustomHttpMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortAnnoName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHttpAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

