/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.refactoring.lang.html;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.lang.ExtractIncludeFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIncludeFromHTMLHandler
extends ExtractIncludeFileBase<XmlTagChild> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.html.ExtractIncludeFromHTMLHandler");

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            ExtractIncludeFromHTMLHandler.$$$reportNull$$$0(0);
        }
        return file.getLanguage() == HTMLLanguage.INSTANCE || file.getLanguage() == XHTMLLanguage.INSTANCE;
    }

    protected void doReplaceRange(String includePath, XmlTagChild first, XmlTagChild last) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            XmlTag parentTag = first.getParentTag();
            LOG.assertTrue(parentTag != null);
            try {
                XmlElementDescriptor descriptor = parentTag.getDescriptor();
                LOG.assertTrue(descriptor != null);
                @NonNls String name = descriptor.getName();
                if ("script".equals(name)) {
                    parentTag.setAttribute("src", includePath);
                    LOG.assertTrue(first.getParent() == parentTag);
                    parentTag.deleteChildRange((PsiElement)first, (PsiElement)last);
                } else if ("style".equals(name)) {
                    String media;
                    XmlTag linkTag = parentTag.createChildTag("link", parentTag.getNamespace(), null, false);
                    linkTag.setAttribute("href", includePath);
                    linkTag.setAttribute("rel", "stylesheet");
                    String type = parentTag.getAttributeValue("type");
                    if (type != null) {
                        linkTag.setAttribute("type", type);
                    }
                    if ((media = parentTag.getAttributeValue("media")) != null) {
                        linkTag.setAttribute("media", media);
                    }
                    parentTag.replace((PsiElement)linkTag);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    protected boolean verifyChildRange(XmlTagChild first, XmlTagChild last) {
        Language language = first.getLanguage();
        if (first != last || ((HTMLLanguage)Language.findInstance(HTMLLanguage.class)).equals(language) || ((XHTMLLanguage)Language.findInstance(XHTMLLanguage.class)).equals(language)) {
            return false;
        }
        XmlTag parentTag = first.getParentTag();
        return parentTag != null && ExtractIncludeFromHTMLHandler.isAvailableOnDescriptor(parentTag.getDescriptor());
    }

    @Nullable
    protected Pair<XmlTagChild, XmlTagChild> findPairToExtract(int start, int end) {
        Object[] children;
        Pair range = XmlUtil.findTagChildrenInRange((PsiFile)this.myIncludingFile, (int)start, (int)end);
        if (range != null && range.first == range.second && range.first instanceof XmlTag && ExtractIncludeFromHTMLHandler.isAvailableOnDescriptor(((XmlTag)range.first).getDescriptor()) && (children = ((XmlTag)range.first).getValue().getChildren()).length > 0) {
            return Pair.create((Object)((XmlTagChild)ArrayUtil.getFirstElement((Object[])children)), (Object)((XmlTagChild)ArrayUtil.getLastElement((Object[])children)));
        }
        return range;
    }

    private static boolean isAvailableOnDescriptor(@Nullable XmlElementDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        @NonNls String name = descriptor.getName();
        return "style".equals(name) || "script".equals(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/htmltools/refactoring/lang/html/ExtractIncludeFromHTMLHandler", "isAvailableForFile"));
    }
}

