/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.html;

import com.intellij.htmltools.html.HtmlTagIdIndex;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlGotoSymbolProvider
implements ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            HtmlGotoSymbolProvider.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            HtmlGotoSymbolProvider.$$$reportNull$$$0(1);
        }
        FileBasedIndex.getInstance().processAllKeys(HtmlTagIdIndex.INDEX, name -> processor.process(name) && processor.process((Object)("#" + name)), scope, filter);
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            HtmlGotoSymbolProvider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            HtmlGotoSymbolProvider.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            HtmlGotoSymbolProvider.$$$reportNull$$$0(4);
        }
        String idName = StringUtil.trimStart((String)name, (String)"#");
        FileBasedIndex.getInstance().processValues(HtmlTagIdIndex.INDEX, (Object)idName, null, (file, value) -> processor.process((Object)new OffsetNavigationItem(parameters, file, (Integer)value, name)), parameters.getSearchScope(), parameters.getIdFilter());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/htmltools/html/HtmlGotoSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class OffsetNavigationItem
    implements NavigationItem {
        private final VirtualFile myFile;
        private final Integer myValue;
        private final String myName;
        private final Project myProject;

        private OffsetNavigationItem(FindSymbolParameters parameters, VirtualFile file, Integer value, String name) {
            this.myProject = parameters.getProject();
            this.myFile = file;
            this.myValue = value;
            this.myName = name;
        }

        public void navigate(boolean requestFocus) {
            new OpenFileDescriptor(this.myProject, this.myFile, this.myValue.intValue()).navigate(requestFocus);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public String getName() {
            return this.myName;
        }

        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                public String getPresentableText() {
                    return myName;
                }

                @Nullable
                public String getLocationString() {
                    PsiFile psiFile = PsiManager.getInstance((Project)myProject).findFile(myFile);
                    return psiFile != null ? "(" + SymbolPresentationUtil.getFilePathPresentation((PsiFile)psiFile) + ")" : null;
                }

                public Icon getIcon(boolean unused) {
                    return AllIcons.Xml.Html_id;
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetNavigationItem item = (OffsetNavigationItem)o;
            return this.myFile.equals(item.myFile) && this.myValue.equals(item.myValue);
        }

        public int hashCode() {
            return Objects.hash(this.myFile, this.myValue);
        }
    }
}

