/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularCollectionHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

class SingularGuavaCollectionHandler
extends SingularCollectionHandler {
    private final boolean sortedCollection;
    private final String typeCollectionQualifiedName;

    SingularGuavaCollectionHandler(String collectionQualifiedName, boolean sortedCollection) {
        super(collectionQualifiedName);
        this.sortedCollection = sortedCollection;
        this.typeCollectionQualifiedName = "com.google.common.collect.ImmutableCollection".equals(collectionQualifiedName) ? "com.google.common.collect.ImmutableList" : collectionQualifiedName;
    }

    @Override
    @NotNull
    protected PsiType getBuilderFieldType(@NotNull PsiType psiFieldType, @NotNull Project project) {
        if (psiFieldType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(1);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiType elementType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager);
        PsiType psiType = PsiTypeUtil.createCollectionType(psiManager, this.typeCollectionQualifiedName + ".Builder", elementType);
        if (psiType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @Override
    protected void addAllMethodParameter(@NotNull LombokLightMethodBuilder methodBuilder, @NotNull PsiType psiFieldType, @NotNull String singularName) {
        if (methodBuilder == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(3);
        }
        if (psiFieldType == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(4);
        }
        if (singularName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(5);
        }
        PsiManager psiManager = methodBuilder.getManager();
        PsiType elementType = PsiTypeUtil.extractAllElementType(psiFieldType, psiManager);
        PsiType collectionType = PsiTypeUtil.createCollectionType(psiManager, "java.lang.Iterable", elementType);
        methodBuilder.withParameter(singularName, collectionType);
    }

    @Override
    protected String getClearMethodBody(@NotNull BuilderInfo info) {
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(6);
        }
        String codeBlockFormat = "this.{0} = null;\nreturn {1};";
        return MessageFormat.format("this.{0} = null;\nreturn {1};", info.getFieldName(), info.getBuilderChainResult());
    }

    @Override
    protected String getOneMethodBody(@NotNull String singularName, @NotNull BuilderInfo info) {
        if (singularName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(7);
        }
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(8);
        }
        String codeBlockTemplate = "if (this.{0} == null) this.{0} = {2}.{3}; \nthis.{0}.add({1});\nreturn {4};";
        return MessageFormat.format("if (this.{0} == null) this.{0} = {2}.{3}; \nthis.{0}.add({1});\nreturn {4};", info.getFieldName(), singularName, this.typeCollectionQualifiedName, this.sortedCollection ? "naturalOrder()" : "builder()", info.getBuilderChainResult());
    }

    @Override
    protected String getAllMethodBody(@NotNull String singularName, @NotNull BuilderInfo info) {
        if (singularName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(9);
        }
        if (info == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(10);
        }
        String codeBlockTemplate = "if (this.{0} == null) this.{0} = {1}.{2}; \nthis.{0}.addAll({0});\nreturn {3};";
        return MessageFormat.format("if (this.{0} == null) this.{0} = {1}.{2}; \nthis.{0}.addAll({0});\nreturn {3};", singularName, this.typeCollectionQualifiedName, this.sortedCollection ? "naturalOrder()" : "builder()", info.getBuilderChainResult());
    }

    @Override
    public String renderBuildCode(@NotNull PsiVariable psiVariable, @NotNull String fieldName, @NotNull String builderVariable) {
        if (psiVariable == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(11);
        }
        if (fieldName == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(12);
        }
        if (builderVariable == null) {
            SingularGuavaCollectionHandler.$$$reportNull$$$0(13);
        }
        PsiManager psiManager = psiVariable.getManager();
        PsiType psiFieldType = psiVariable.getType();
        PsiType elementType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager);
        return MessageFormat.format("{2}<{1}> {0} = {4}.{0} == null ? {3}.<{1}>of() : {4}.{0}.build();\n", fieldName, elementType.getCanonicalText(false), this.collectionQualifiedName, this.typeCollectionQualifiedName, builderVariable);
    }

    @Override
    protected String getEmptyCollectionCall() {
        return this.typeCollectionQualifiedName + ".builder()";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFieldType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/singular/SingularGuavaCollectionHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBuilder";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singularName";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/SingularGuavaCollectionHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFieldType";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAllMethodParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClearMethodBody";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOneMethodBody";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodBody";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderBuildCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

