/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.introduceParameter;

import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.refactoring.lang.jsp.introduceParameter.JspIntroduceParameterHandler;
import com.intellij.refactoring.lang.jsp.introduceParameter.JspIntroduceParameterProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class JspIntroduceParameterDialog
extends RefactoringDialog {
    private JTextField myNameField;
    private JPanel myPanel;
    private JButton myEditTemplateButton;
    private final JspFile myTagFile;
    private final String mySelectedText;
    private final Editor myEditor;
    private final JspIntroduceParameterHandler myHandler;

    protected JspIntroduceParameterDialog(JspFile tagFile, Editor editor, String selectedText, JspIntroduceParameterHandler handler) {
        super(tagFile.getProject(), true);
        this.$$$setupUI$$$();
        this.setTitle(handler.getDialogTitle());
        this.myHandler = handler;
        this.myTagFile = tagFile;
        this.myEditor = editor;
        this.mySelectedText = selectedText;
        this.myNameField.setText(JspIntroduceParameterDialog.guessParameterName(selectedText));
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JspIntroduceParameterDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterDialog$1", "textChanged"));
            }
        });
        this.myEditTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveTemplatesConfigurable configurable = new LiveTemplatesConfigurable();
                ShowSettingsUtil.getInstance().editConfigurable(JspIntroduceParameterDialog.this.myProject, (Configurable)configurable, () -> configurable.getTemplateListPanel().editTemplate(JspIntroduceParameterDialog.this.createProcessor().getTemplate()));
            }
        });
        this.init();
    }

    private static String guessParameterName(String text) {
        StringBuilder builder = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (!Character.isLetter(c)) break;
            if (builder.length() > 20) {
                return "";
            }
            builder.append(c);
        }
        return StringUtil.decapitalize((String)builder.toString());
    }

    protected void canRun() throws ConfigurationException {
        if (StringUtil.isEmpty((String)this.getParameterName())) {
            throw new ConfigurationException(JavaeeJspBundle.message("dialog.message.name.should.not.be.empty", new Object[0]));
        }
    }

    protected void doAction() {
        this.invokeRefactoring(this.createProcessor());
    }

    private JspIntroduceParameterProcessor createProcessor() {
        return this.myHandler.createIntroduceParameterProcessor(this.myTagFile, this.myEditor, this.getParameterName(), this.mySelectedText);
    }

    private String getParameterName() {
        return this.myNameField.getText();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Enter new attribute's name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(22);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditTemplateButton = jButton = new JButton();
        jButton.setText("Edit template...");
        jButton.setMnemonic('T');
        jButton.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

