/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.extractTag;

import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtractTagHandler {
    private static final ExtensionPointName<ExtractTagHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.javaee.jsp.extractTagHandler");

    @Nullable
    public static ExtractTagHandler getHandler(@NotNull BaseJspFile file) {
        if (file == null) {
            ExtractTagHandler.$$$reportNull$$$0(0);
        }
        for (ExtractTagHandler handler : EP_NAME.getExtensionList()) {
            if (!handler.acceptFile(file)) continue;
            return handler;
        }
        return null;
    }

    protected abstract boolean acceptFile(BaseJspFile var1);

    @NlsActions.ActionText
    public String getActionName() {
        return JavaeeJspBundle.message("action.extract.jsp.tag.text", new Object[0]);
    }

    public boolean isAvailableOnSelection(Editor editor, PsiFile file) {
        return editor.getSelectionModel().hasSelection();
    }

    @Nullable
    public String getTagFileText(Editor editor, PsiFile file) {
        return editor.getSelectionModel().getSelectedText();
    }

    public abstract String getTagExtension();

    public String getTagFileLocation() {
        return "/WEB-INF/tags";
    }

    public String guessLocation(VirtualFile dir) {
        return dir.getPath() + this.getTagFileLocation();
    }

    public abstract void addDeclaration(XmlTag var1, BaseJspFile var2, String var3, String var4);

    @Nullable
    public abstract String getExistingPrefix(BaseJspFile var1, String var2);

    @Nullable
    @NlsSafe
    public String validateLocation(String locationPath) {
        if (!(locationPath + "/").contains(this.getTagFileLocation() + "/")) {
            return "Tag files should be located under '" + this.getTagFileLocation() + "' directory";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/lang/jsp/extractTag/ExtractTagHandler", "getHandler"));
    }
}

