/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.JspEncodingInAttributeReferenceProvider;
import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.javaee.web.WebUtil;
import com.intellij.jsp.index.JspDirectiveCollector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JspxIncludePathReferenceProvider;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.behavior.CDATAOnAnyEncodedPolicy;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JavaJspElementVisitor;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JspUtil
extends BaseJspUtil {
    private static final Logger LOG = Logger.getInstance(JspUtil.class);
    @NonNls
    public static final String JSF_CORE_TAGLIB_URI = "http://java.sun.com/jsf/core";
    @NonNls
    public static final String JSF_HTML_TAGLIB_URI = "http://java.sun.com/jsf/html";

    private JspUtil() {
    }

    public static int escapeCharsInJspContext(JspFile file, int offset, String toEscape) throws IncorrectOperationException {
        PsiElement elementAtInJavaTree;
        if (!XmlUtil.toCode((String)toEscape) || file.getLanguage() != JSPXLanguage.INSTANCE) {
            return 0;
        }
        XmlFile psiFile = (XmlFile)file.getViewProvider().getPsi((Language)JSPXLanguage.INSTANCE);
        XmlDocument document = psiFile.getDocument();
        PsiElement elementAt = document.findElementAt(offset);
        if (elementAt == null && offset > 0) {
            elementAt = document.findElementAt(offset - 1);
        }
        if (elementAt == null) {
            return 0;
        }
        ASTNode cdata = TreeUtil.findParent((ASTNode)elementAt.getNode(), (IElementType)XmlElementType.XML_CDATA);
        if (cdata != null) {
            return 0;
        }
        XmlText parentOfType = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)elementAt, XmlText.class);
        if (parentOfType == null) {
            return 0;
        }
        PsiClass aClass = file.getJavaClass();
        if (aClass != null && (elementAtInJavaTree = aClass.findElementAt(offset)) instanceof OuterLanguageElement) {
            return 0;
        }
        FileElement cdataElement = CDATAOnAnyEncodedPolicy.createCDATAElement((PsiManager)file.getManager(), (CharTable)file.getNode().getCharTable(), (String)parentOfType.getValue());
        parentOfType.getNode().replaceAllChildrenToChildrenOf((ASTNode)cdataElement);
        return "<![CDATA[".length();
    }

    @Nullable
    public static Language getLanguageByContentType(String contentType) {
        if (contentType == null || contentType.isEmpty()) {
            return null;
        }
        int endOfContentMimeType = contentType.indexOf(59);
        if (endOfContentMimeType >= 0) {
            contentType = contentType.substring(0, endOfContentMimeType);
        }
        if (contentType.isEmpty()) {
            return null;
        }
        return (Language)ContainerUtil.getFirstItem((Collection)Language.findInstancesByMimeType((String)contentType), (Object)XMLLanguage.INSTANCE);
    }

    @Nullable
    public static JspFile resolveIncludeDirective(XmlTag tag) {
        PsiFile file = JspUtil.resolveFileInclude(tag);
        if (file == null) {
            return null;
        }
        return JspPsiUtil.getJspFile((PsiElement)file);
    }

    @Nullable
    public static PsiFile resolveFileInclude(XmlTag tag) {
        assert (tag.isValid());
        LOG.assertTrue(JspUtil.getDirectiveKindByTag(tag) == JspDirectiveKind.INCLUDE);
        return JspUtil.resolvePsiFileReferenceInAttribute(tag, "file");
    }

    @Nullable
    public static String getIncludedFilePath(XmlTag tag) {
        return tag.getAttributeValue("file");
    }

    @Nullable
    protected static JspFile resolvePsiFileReferenceInAttribute(XmlTag tag, @NonNls String attributeName) {
        XmlAttribute attribute = tag.getAttribute(attributeName, null);
        if (attribute == null) {
            return null;
        }
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement == null) {
            return null;
        }
        PsiFile file = JspUtil.resolveFileReference((PsiElement)valueElement);
        return file == null ? null : JspPsiUtil.getJspFile((PsiElement)file);
    }

    @Nullable
    public static PsiFileSystemItem resolveReferenceSet(FileReferenceSet referenceSet, PsiFile context) {
        FileReference lastReference = referenceSet.getLastReference();
        if (lastReference == null) {
            return null;
        }
        ResolveResult[] results = lastReference.multiResolve(false);
        if (results.length == 0) {
            return null;
        }
        for (ResolveResult result : results) {
            if (result != null) continue;
            LOG.error(lastReference + " returned null");
        }
        if (results.length == 1) {
            return (PsiFileSystemItem)results[0].getElement();
        }
        PsiFileSystemItem psiFile = null;
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null) {
            return (PsiFileSystemItem)results[0].getElement();
        }
        String path = virtualFile.getParent().getPath();
        for (ResolveResult result : results) {
            PsiFileSystemItem file;
            if (!result.isValidResult() || !(result.getElement() instanceof PsiFileSystemItem) || !(file = (PsiFileSystemItem)result.getElement()).getVirtualFile().getPath().startsWith(path) || psiFile != null && file.getVirtualFile().getPath().length() >= psiFile.getVirtualFile().getPath().length()) continue;
            psiFile = file;
        }
        return psiFile != null ? psiFile : (PsiFileSystemItem)results[0].getElement();
    }

    @Nullable
    private static PsiFile resolveFileReference(@NotNull PsiElement valueElement) {
        FileReferenceSet referenceSet;
        PsiFileSystemItem item;
        if (valueElement == null) {
            JspUtil.$$$reportNull$$$0(0);
        }
        return (item = JspUtil.resolveReferenceSet(referenceSet = JspxIncludePathReferenceProvider.getFileReferenceSet((String)StringUtil.unquoteString((String)valueElement.getText()), (PsiElement)valueElement, (int)1, null), valueElement.getContainingFile())) instanceof PsiFile ? (PsiFile)item : null;
    }

    @Nullable
    public static Module getModuleForPsiElement(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            JspUtil.$$$reportNull$$$0(1);
        }
        return (file = JspPsiUtil.getJspFile((PsiElement)element.getContainingFile()).getVirtualFile()) == null ? null : ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getModuleForFile(file);
    }

    public static <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T jspFile, Processor<? super T> visitor, boolean includesOnly) {
        Set<T> files = JspUtil.collectAllIncludedFilesRecursively(jspFile, includesOnly);
        for (T file : files) {
            if (visitor.process(file)) continue;
            return;
        }
    }

    public static <T extends BaseJspFile> Set<T> collectAllIncludedFilesRecursively(T jspFile, boolean includesOnly) {
        HashSet result = new HashSet(10);
        JspUtil.collectAllIncludedFilesRecursively(jspFile, result, includesOnly, DumbService.getInstance((Project)jspFile.getProject()).isDumb());
        return result;
    }

    private static <T extends BaseJspFile> void collectAllIncludedFilesRecursively(BaseJspFile jspFile, Set<? super T> result, boolean includesOnly, boolean dumbMode) {
        JspUtil.addPreludes(jspFile, result, includesOnly, dumbMode);
        JspUtil.addIncludes(jspFile, result, includesOnly, dumbMode);
        JspUtil.addCodas(jspFile, result, includesOnly, dumbMode);
    }

    public static <T extends BaseJspFile> void addIncludes(BaseJspFile jspFile, final Set<? super T> result, boolean includesOnly, boolean dumbMode) {
        if (dumbMode) {
            Collection<XmlTag> tags = JspDirectiveCollector.collectDirectives(jspFile, JspDirectiveKind.INCLUDE);
            for (XmlTag tag : tags) {
                JspFile file = JspUtil.resolveIncludeDirective(tag);
                if (file == null || !result.add(file)) continue;
                JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, result, true, true);
            }
        } else {
            JspFileIndex.getInstance(jspFile.getProject()).traverseIncludesGraph(jspFile, new JspFileIndex.JspFileProcessor(){

                @Override
                public boolean process(@NotNull BaseJspFile file, int includeDirectiveOffset, boolean isInclude) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result.add(file);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/jsp/JspUtil$1", "process"));
                }
            }, includesOnly);
        }
    }

    public static <T extends BaseJspFile> void addPreludes(BaseJspFile jspFile, Set<? super T> toVisit, boolean includesOnly, boolean dumbMode) {
        for (PathReference prelude : WebUtil.getPreludes((BaseJspFile)jspFile)) {
            PsiElement file = prelude.resolve();
            if (!(file instanceof BaseJspFile) || !toVisit.add((BaseJspFile)file)) continue;
            JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, toVisit, includesOnly, dumbMode);
        }
    }

    private static <T extends BaseJspFile> void addCodas(BaseJspFile jspFile, Set<? super T> toVisit, boolean includesOnly, boolean dumbMode) {
        for (PathReference prelude : WebUtil.getCodas((BaseJspFile)jspFile)) {
            PsiElement file = prelude.resolve();
            if (!(file instanceof BaseJspFile) || !toVisit.add((BaseJspFile)file)) continue;
            JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, toVisit, includesOnly, dumbMode);
        }
    }

    public static void visitAllIncludes(JspFile jspFile, Set<? extends XmlTag> toVisit, JavaJspElementVisitor visitor) {
        HashSet<JspFile> filesToVisit = new HashSet<JspFile>(10);
        boolean dumbMode = DumbService.getInstance((Project)jspFile.getProject()).isDumb();
        JspUtil.addPreludes((BaseJspFile)jspFile, filesToVisit, true, dumbMode);
        for (XmlTag xmlTag : toVisit) {
            JspFile file = JspUtil.resolveIncludeDirective(xmlTag);
            if (file == null || !filesToVisit.add(file)) continue;
            JspUtil.collectAllIncludedFilesRecursively((BaseJspFile)file, filesToVisit, true, dumbMode);
        }
        for (JspFile jspFile2 : filesToVisit) {
            visitor.visitJspFile(jspFile2);
        }
    }

    @Nullable
    public static String checkValidNameFromAttribute(XmlTag tag) {
        @NonNls String requiredValue = tag.getAttributeValue("required");
        if ("false".equals(requiredValue)) {
            return "name.from.attribute.should.be.required";
        }
        String typeValue = tag.getAttributeValue("type");
        if (!"java.lang.String".equals(typeValue)) {
            return "name.from.attribute.should.be.java.lang.String";
        }
        @NonNls String runtimeValue = tag.getAttributeValue("rtexprvalue");
        if (!"false".equals(runtimeValue)) {
            return "name.from.attribute.should.not.be.rtexprvalue";
        }
        return null;
    }

    @Nullable
    private static Charset detectCharsetFromDirectives(@NotNull CharSequence content, @NotNull Language language) {
        ParserDefinition definition;
        if (content == null) {
            JspUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            JspUtil.$$$reportNull$$$0(3);
        }
        if ((definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)) == null) {
            LOG.error(language.getID());
            return null;
        }
        Lexer lexer = definition.createLexer(null);
        lexer.start(content);
        final Ref charsetNameRef = new Ref();
        CharTableImpl charTable = new CharTableImpl();
        while (lexer.getTokenType() != null) {
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == BaseJspElementType.JSP_DIRECTIVE) {
                ASTNode parsed = BaseJspElementType.JSP_DIRECTIVE.parse(LexerUtil.getTokenText((Lexer)lexer), (CharTable)charTable);
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project = projects.length == 0 ? ProjectManager.getInstance().getDefaultProject() : projects[0];
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                new DummyHolder(psiManager, (TreeElement)parsed, null, null, null, BaseJspElementType.JSP_DIRECTIVE.getLanguage());
                PsiElement psiElement = parsed.getPsi();
                assert (psiElement != null);
                psiElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue value) {
                        for (PsiReference reference : JspEncodingInAttributeReferenceProvider.getReferencesByElement((PsiElement)value)) {
                            if (!(reference instanceof XmlEncodingReference) || reference.resolve() == null) continue;
                            XmlEncodingReference prev = (XmlEncodingReference)charsetNameRef.get();
                            XmlEncodingReference xmlRef = (XmlEncodingReference)reference;
                            if (prev != null && prev.compareTo(xmlRef) >= 0) continue;
                            charsetNameRef.set((Object)xmlRef);
                        }
                        super.visitXmlAttributeValue(value);
                    }
                });
            }
            lexer.advance();
        }
        XmlEncodingReference ref = (XmlEncodingReference)charsetNameRef.get();
        String name = ref == null ? null : ref.getCanonicalText();
        return CharsetToolkit.forName((String)name);
    }

    @Nullable
    private static Charset detectCharsetFromWebXml(Project project, VirtualFile virtualFile) {
        Ref result = new Ref();
        WebUtil.processMatchingJspGroups((Project)project, (VirtualFile)virtualFile, group -> {
            result.set((Object)CharsetToolkit.forName((String)((String)group.getPageEncoding().getValue())));
            return !result.isNull();
        });
        return (Charset)result.get();
    }

    @Nullable
    public static Charset detectCharsetAsPerJspSpec(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content, @NotNull Language language) {
        if (content == null) {
            JspUtil.$$$reportNull$$$0(4);
        }
        if (language == null) {
            JspUtil.$$$reportNull$$$0(5);
        }
        return (Charset)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            Charset charset;
            if (project != null && project.isInitialized() && !project.isDisposed() && file != null && file.isValid() && !NoAccessDuringPsiEvents.isInsideEventProcessing() && FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && (charset = JspUtil.detectCharsetFromWebXml(project, file)) != null) {
                return charset;
            }
            return JspUtil.detectCharsetFromDirectives(content, language);
        }));
    }

    @Nullable
    public static String detectCharsetAsPerJspSpec(VirtualFile jspFile, byte[] content, Language language) {
        @NonNls String strContent = new String(content, StandardCharsets.ISO_8859_1);
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)jspFile);
        Charset charset = JspUtil.detectCharsetAsPerJspSpec(project, jspFile, strContent, language);
        return charset == null ? null : charset.name();
    }

    public static boolean isFacesJsp(BaseJspFile jspFile) {
        XmlDocument document = jspFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return false;
        }
        for (String namespace : rootTag.knownNamespaces()) {
            if (JSF_CORE_TAGLIB_URI.equals(namespace)) {
                return true;
            }
            if (!JSF_HTML_TAGLIB_URI.equals(namespace)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/jsp/JspUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFileReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleForPsiElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCharsetFromDirectives";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCharsetAsPerJspSpec";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

