/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class TaglibsModificationTracker
extends SimpleModificationTracker
implements ModificationTracker {
    @NonNls
    private static final String FACELETS_TAGLIB = ".taglib.xml";
    private final VirtualFileListener myFileListener = new VirtualFileListener(){

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            TaglibsModificationTracker.this.incModificationCount();
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(1);
            }
            this.fileChanged(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(2);
            }
            this.fileChanged((VirtualFileEvent)event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(3);
            }
            if (event.getPropertyName().equals("name")) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(4);
            }
            this.fileChanged((VirtualFileEvent)event);
        }

        private void fileChanged(VirtualFileEvent event) {
            if ("tag".equals(event.getFile().getExtension())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                1.$$$reportNull$$$0(5);
            }
            if (TaglibsModificationTracker.isTaglib((file = event.getFile()).getName()) || "jar".equals(file.getExtension())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final PsiTreeChangeListener myPsiListener = new PsiTreeChangeAdapter(){

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                2.$$$reportNull$$$0(0);
            }
            this.processChange(event.getFile());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                2.$$$reportNull$$$0(1);
            }
            this.processChange(event.getFile());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                2.$$$reportNull$$$0(2);
            }
            this.processChange(event.getFile());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                2.$$$reportNull$$$0(3);
            }
            this.processChange(event.getFile());
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                2.$$$reportNull$$$0(4);
            }
            if ("propFileTypes".equals(event.getPropertyName()) || "propUnloadedPsi".equals(event.getPropertyName())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        private void processChange(PsiFile file) {
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null && TaglibsModificationTracker.isTaglib(virtualFile.getName())) {
                TaglibsModificationTracker.this.incModificationCount();
            }
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                2.$$$reportNull$$$0(5);
            }
            this.processChange(event.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/psi/impl/source/jsp/TaglibsModificationTracker$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    TaglibsModificationTracker(Project project, Disposable parentDisposable) {
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiListener, parentDisposable);
        VirtualFileManager.getInstance().addVirtualFileListener(this.myFileListener, parentDisposable);
    }

    private static boolean isTaglib(@NonNls String name) {
        return name != null && (name.endsWith(".tld") || name.endsWith(FACELETS_TAGLIB) || name.endsWith(".tag"));
    }
}

