/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.FactoryMap;
import org.jetbrains.annotations.NonNls;

public abstract class TaglibProcessor {
    @NonNls
    public static final String TLD_EXTENSION = ".tld";
    private final JspFile myContext;

    protected TaglibProcessor(JspFile context) {
        this.myContext = context;
    }

    public boolean isTaglib(String fileName) {
        return fileName.endsWith(TLD_EXTENSION);
    }

    public abstract boolean execute(String var1, XmlFile var2, FactoryMap<String, XmlFile> var3);

    public JspFile getContext() {
        return this.myContext;
    }

    public static class FindTagLibByUriProcessor
    extends TaglibProcessor {
        protected final String myUri;
        public PsiFile result;

        public FindTagLibByUriProcessor(String uri, JspFile context) {
            super(context);
            this.myUri = uri;
        }

        @Override
        public boolean execute(String uri, XmlFile taglibFile, FactoryMap<String, XmlFile> map) {
            if (!map.containsKey((Object)uri)) {
                map.put((Object)uri, (Object)taglibFile);
            }
            if (this.myUri.equals(uri)) {
                this.result = taglibFile;
                return false;
            }
            return true;
        }
    }

    public static class CollectUrisProcessor
    extends TaglibProcessor {
        protected CollectUrisProcessor(JspFile context) {
            super(context);
        }

        @Override
        public boolean execute(String uri, XmlFile taglibFile, FactoryMap<String, XmlFile> map) {
            if (!map.containsKey((Object)uri)) {
                map.put((Object)uri, (Object)taglibFile);
            }
            return true;
        }
    }
}

