/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.idCache;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.idCache.JavaFilterLexer;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.java.IJavaDocElementType;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.xml.XmlTokenType;

public class JspxFilterLexer
extends JavaFilterLexer {
    private final Language myJavaLanguage = JavaLanguage.INSTANCE;
    private final Language myXmlLanguage = XMLLanguage.INSTANCE;
    private final Language myELLanguage = ELLanguage.INSTANCE;
    private final Language myAnyLanguage = Language.ANY;

    public JspxFilterLexer(Lexer originalLexer, OccurrenceConsumer table) {
        super(originalLexer, table);
    }

    public void advance() {
        IElementType tokenType = this.getDelegate().getTokenType();
        if (tokenType instanceof IJavaElementType || tokenType instanceof IJavaDocElementType) {
            super.advance();
        } else {
            if (tokenType == XmlTokenType.XML_COMMENT_CHARACTERS) {
                this.scanWordsInToken(2, false, false);
                this.advanceTodoItemCountsInToken();
            } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                this.scanWordsInToken(24, true, false);
            } else if (tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME || tokenType == ELTokenType.JSP_EL_IDENTIFIER || tokenType.getLanguage() != this.myJavaLanguage && tokenType.getLanguage() != this.myXmlLanguage && tokenType.getLanguage() != this.myELLanguage && tokenType.getLanguage() != this.myAnyLanguage) {
                boolean inComments = CacheUtil.isInComments((IElementType)tokenType);
                int mask = inComments ? 2 : 24;
                this.scanWordsInToken(mask, false, false);
                if (inComments) {
                    this.advanceTodoItemCountsInToken();
                }
            } else {
                this.scanWordsInToken(16, false, false);
            }
            this.getDelegate().advance();
        }
    }
}

