/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.jspx.JspFormattingPolicy;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.JspBlock;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside;
import com.intellij.psi.impl.source.jsp.jspXml.JspOuterLanguageElement;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class JspFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            JspFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = formattingContext.getContainingFile();
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile);
        Block rootBlock = JspFormattingModelBuilder.createJspRoot(formattingContext.getPsiElement(), formattingContext.getCodeStyleSettings(), (FormattingDocumentModel)documentModel);
        return new PsiBasedFormatterModelWithShiftIndentInside(psiFile, rootBlock, documentModel);
    }

    private static Block createJspRoot(PsiElement element, CodeStyleSettings settings, FormattingDocumentModel documentModel) {
        XmlTag jspTag;
        PsiFile file = element.getContainingFile();
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        assert (jspFile != null);
        Language baseLanguage = jspFile.getViewProvider().getTemplateDataLanguage();
        if (element instanceof JspOuterLanguageElement && (jspTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)jspFile.findElementAt(element.getTextRange().getStartOffset()), XmlTag.class)) != null) {
            element = jspTag;
        }
        if (baseLanguage == HTMLLanguage.INSTANCE || baseLanguage == XHTMLLanguage.INSTANCE) {
            return new JspBlock(element.getNode(), null, null, (XmlFormattingPolicy)new JspFormattingPolicy(settings, documentModel), null, null);
        }
        if (baseLanguage == XMLLanguage.INSTANCE) {
            return new JspBlock(element.getNode(), null, null, (XmlFormattingPolicy)new XmlPolicyWithJspXmlTag(settings, documentModel), null, null);
        }
        FormattingModelBuilder builder = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(baseLanguage);
        if (builder != null) {
            return builder.createModel(FormattingContext.create((PsiElement)file.getViewProvider().getPsi(baseLanguage), (CodeStyleSettings)settings)).getRootBlock();
        }
        return new ReadOnlyBlock((ASTNode)file.getNode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingContext", "com/intellij/lang/jsp/JspFormattingModelBuilder", "createModel"));
    }

    public static class XmlPolicyWithJspXmlTag
    extends XmlPolicy {
        public XmlPolicyWithJspXmlTag(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
            super(settings, documentModel);
        }

        public boolean indentChildrenOf(XmlTag parentTag) {
            return !(parentTag instanceof JspXmlRootTag);
        }
    }
}

