/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.jsp.JspFileViewProvider;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jsp.JspxFileViewProviderImpl;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspFileViewProviderImpl
extends JspxFileViewProviderImpl
implements JspFileViewProvider,
ModificationTracker {
    private volatile Set<Language> myLanguages;
    private Set<Language> myFixedLanguages;
    private final CachedValue<PrefixesWithLanguage> myLocalPrefixes;
    private final CachedValue<Language> myTemplateLanguage;
    private final SimpleModificationTracker myContentModificationCount = new SimpleModificationTracker();

    public Set<String> getXmlNsPrefixes(CharSequence buffer) {
        return ((PrefixesWithLanguage)this.myLocalPrefixes.getValue()).getKnownPrefixes();
    }

    public long getModificationCount() {
        return this.myContentModificationCount.getModificationCount();
    }

    JspFileViewProviderImpl(PsiManager manager, VirtualFile virtualFile, boolean isPhysical) {
        super(manager, virtualFile, isPhysical);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)manager.getProject());
        this.myLocalPrefixes = cachedValuesManager.createCachedValue(() -> {
            PrefixesWithLanguage prefixes = JspWithOtherWorldIntegrationService.getInstance().getLocalPrefixes(this, this.getContents());
            return CachedValueProvider.Result.create((Object)prefixes, (Object[])new Object[]{this, this.getVirtualFile()});
        }, false);
        this.myTemplateLanguage = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create((Object)this.getKeyPrefixes(null).getTemplateLanguage(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @Override
    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = (Language)ReadAction.compute(() -> (Language)this.myTemplateLanguage.getValue());
        if (language == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    protected PrefixesWithLanguage getKeyPrefixes(@Nullable CharSequence newContent) {
        PrefixesWithLanguage prefixesWithLanguage = newContent == null ? (PrefixesWithLanguage)this.myLocalPrefixes.getValue() : JspWithOtherWorldIntegrationService.getInstance().getLocalPrefixes(this, newContent);
        if (prefixesWithLanguage == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(1);
        }
        return prefixesWithLanguage;
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        NewJspLanguage newJspLanguage = NewJspLanguage.getInstance();
        if (newJspLanguage == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(2);
        }
        return newJspLanguage;
    }

    @Override
    @NotNull
    protected JspFileViewProviderImpl cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(3);
        }
        return new JspFileViewProviderImpl((PsiManager)this.getManager(), copy, false){

            @Override
            @NotNull
            protected PrefixesWithLanguage getKeyPrefixes(CharSequence newContent) {
                PrefixesWithLanguage prefixesWithLanguage = JspFileViewProviderImpl.this.getKeyPrefixes(newContent);
                if (prefixesWithLanguage == null) {
                    1.$$$reportNull$$$0(0);
                }
                return prefixesWithLanguage;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFileViewProviderImpl$1", "getKeyPrefixes"));
            }
        };
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Object> languages = this.myFixedLanguages;
        if (languages != null) {
            LinkedHashSet linkedHashSet = languages;
            if (linkedHashSet == null) {
                JspFileViewProviderImpl.$$$reportNull$$$0(4);
            }
            return linkedHashSet;
        }
        languages = this.myLanguages;
        if (languages == null) {
            this.myLanguages = languages = ContainerUtil.newLinkedHashSet((Object[])new Language[]{NewJspLanguage.getInstance(), this.getTemplateDataLanguage(), JspWithOtherWorldIntegrationService.getJavaLanguage()});
        }
        LinkedHashSet linkedHashSet = languages;
        if (linkedHashSet == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    public boolean hasLanguage(@NotNull Language language) {
        if (language == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(6);
        }
        return language.equals(JspWithOtherWorldIntegrationService.getJavaLanguage()) || super.hasLanguage(language);
    }

    public void beforeContentsSynchronized() {
        super.beforeContentsSynchronized();
        this.myFixedLanguages = this.myLanguages;
        this.clearCaches();
    }

    public void clearCaches() {
        this.myLanguages = null;
        this.myContentModificationCount.incModificationCount();
    }

    public void contentsSynchronized() {
        super.contentsSynchronized();
        this.myFixedLanguages = null;
    }

    @Override
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        if (lang == null) {
            JspFileViewProviderImpl.$$$reportNull$$$0(7);
        }
        if ((psiFile = super.createFile(lang)) == null && lang == this.getTemplateDataLanguage()) {
            return new JspXmlFile((FileViewProvider)this);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/jsp/JspFileViewProviderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyPrefixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/jsp/JspFileViewProviderImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PrefixesWithLanguage {
        private final Set<String> myKnownPrefixes = Collections.newSetFromMap(new ConcurrentHashMap());
        private Language myTemplateLanguage;

        public PrefixesWithLanguage() {
            this.myKnownPrefixes.add("xml");
        }

        public void setTemplateLanguage(Language templateLanguage) {
            this.myTemplateLanguage = templateLanguage;
        }

        public void addKnownPrefixes(Collection<String> prefixes) {
            this.myKnownPrefixes.addAll(prefixes);
        }

        public Language getTemplateLanguage() {
            return this.isLanguageSet() ? this.myTemplateLanguage : HTMLLanguage.INSTANCE;
        }

        public Set<String> getKnownPrefixes() {
            return this.myKnownPrefixes;
        }

        private boolean isLanguageSet() {
            return this.myTemplateLanguage != null && this.myTemplateLanguage != Language.ANY;
        }
    }
}

