/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.jsp.impl.JspValidationContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.jsp.jspXml.JspDeclaration;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspExpression;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class GenerateXmlViewVisitor
extends XmlRecursiveElementVisitor {
    private StringBuffer myResult = new StringBuffer();
    private final JspValidationContext myContext;
    private XmlTag myCurrentRootTag;
    private int id;
    private final Map<String, String> myUsedNamespacesMap = new HashMap<String, String>();
    private final Set<XmlTag> myVisitedRoots = new HashSet<XmlTag>();

    GenerateXmlViewVisitor(JspValidationContext context) {
        this.myContext = context;
    }

    public void visitXmlTag(XmlTag tag) {
        boolean doOutputOfEndTag;
        XmlAttribute attribute;
        int i;
        XmlAttribute[] attributes;
        boolean isSingleTag;
        boolean isRootTag = tag == this.myCurrentRootTag;
        Object tagName = tag.getName();
        boolean doCDATAEscapeContent = false;
        if ("http://java.sun.com/JSP/Page".equals(tag.getNamespace())) {
            if (tag.getLocalName().equals("directive.include") || tag instanceof JspDirective && "include".equalsIgnoreCase(tag.getLocalName())) {
                PsiFile psiFile;
                XmlAttribute attribute2 = tag.getAttribute("file", null);
                if (attribute2 != null && (psiFile = FileReferenceUtil.findFile((PsiElement)attribute2.getValueElement())) instanceof XmlFile) {
                    XmlFile file = (XmlFile)psiFile;
                    XmlTag previousRoot = this.myCurrentRootTag;
                    XmlDocument document = file.getDocument();
                    XmlTag xmlTag = this.myCurrentRootTag = document == null ? null : document.getRootTag();
                    if (this.myCurrentRootTag != null && !this.myVisitedRoots.contains(this.myCurrentRootTag)) {
                        this.myVisitedRoots.add(this.myCurrentRootTag);
                        this.myCurrentRootTag.accept((PsiElementVisitor)this);
                    }
                    this.myCurrentRootTag = previousRoot;
                }
                return;
            }
            if (tag instanceof JspDirective && "taglib".equalsIgnoreCase(tag.getLocalName())) {
                String prefix = tag.getAttributeValue("prefix");
                String namespace = tag.getNamespaceByPrefix(prefix);
                this.myUsedNamespacesMap.put("xmlns:" + prefix, namespace);
                return;
            }
            if (tag instanceof JspDirective) {
                String s = StringUtil.toLowerCase((String)tag.getLocalName());
                tagName = "directive." + s;
                doCDATAEscapeContent = "declaration".equals(s) || "expression".equals(s) || "scriplet".equals(s);
            } else if (tag instanceof JspScriptlet || tag instanceof JspDeclaration || tag instanceof JspExpression) {
                tagName = "directive." + (tag instanceof JspScriptlet ? "scriplet" : (tag instanceof JspDeclaration ? "desclaration" : "expression"));
                doCDATAEscapeContent = true;
            }
        }
        boolean bl = isSingleTag = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tag.getNode()) != null;
        if (!isRootTag) {
            this.myResult.append("<").append((String)tagName).append(" jsp:id='").append(this.id).append("'");
            this.myContext.setElementWithId(Integer.toString(this.id), (PsiElement)tag);
            ++this.id;
            attributes = tag.getAttributes();
            for (i = 0; i < attributes.length; ++i) {
                attribute = attributes[i];
                this.outputAttribute(attribute.getName(), attribute.getValue());
            }
            this.myResult.append(isSingleTag ? "/>" : ">");
        } else {
            attributes = tag.getAttributes();
            for (i = 0; i < attributes.length; ++i) {
                attribute = attributes[i];
                if (!attribute.isNamespaceDeclaration()) continue;
                this.myUsedNamespacesMap.put(attribute.getName(), attribute.getValue());
            }
        }
        if (!isSingleTag) {
            if (doCDATAEscapeContent) {
                this.myResult.append("<![CDATA[");
            }
            super.visitXmlTag(tag);
            if (doCDATAEscapeContent) {
                this.myResult.append("]]>");
            }
        }
        boolean bl2 = doOutputOfEndTag = !isRootTag && !isSingleTag;
        if (isRootTag && this.myCurrentRootTag == this.myContext.getRootTag()) {
            StringBuffer previousResult = this.myResult;
            this.myResult = new StringBuffer();
            this.myResult.append("<jsp:root");
            this.myUsedNamespacesMap.put("xmlns:jsp", "http://java.sun.com/JSP/Page");
            ArrayList<String> sortedPrefixes = new ArrayList<String>(this.myUsedNamespacesMap.keySet());
            Collections.sort(sortedPrefixes);
            for (String prefix : sortedPrefixes) {
                this.outputAttribute(prefix, this.myUsedNamespacesMap.get(prefix));
            }
            this.myResult.append(">\n");
            previousResult.insert(0, this.myResult.toString());
            this.myResult = previousResult;
            doOutputOfEndTag = true;
            this.myResult.append("\n");
        }
        if (doOutputOfEndTag) {
            this.myResult.append("</").append((String)tagName).append(">");
        }
    }

    private void outputAttribute(String name, String namespace) {
        this.myResult.append(' ').append(name).append("='").append(namespace).append('\'');
    }

    public void visitXmlText(XmlText text) {
        this.myResult.append(text.getText());
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            GenerateXmlViewVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof ELExpression) {
            this.myResult.append(element.getText());
        } else {
            super.visitElement(element);
        }
    }

    public String getXmlView() {
        this.myCurrentRootTag = this.myContext.getRootTag();
        this.myCurrentRootTag.accept((PsiElementVisitor)this);
        return this.myResult.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsp/impl/GenerateXmlViewVisitor", "visitElement"));
    }
}

