/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.jsp.impl.CustomTagSupportUtil;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TaglibReferenceProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionDescriptorImpl
implements FunctionDescriptor {
    private XmlTag myTag;
    private String myName;
    private String myFunctionName;
    private String myFunctionClass;
    private String myFunctionSignature;
    private List<String> myFunctionParameters;
    private int myParameterCount;
    private String myFunctionReturnType;
    private PsiType myFunctionPsiType;
    private String myUsedTagName = "name";
    @NonNls
    private static final String NAME_TAG_NAME = "name";
    @NonNls
    private static final String NAME2_TAG_NAME = "function-name";
    @NonNls
    private static final String FUNCTION_SIGNATURE = "function-signature";

    public FunctionDescriptorImpl() {
    }

    public PsiElement getDeclaration() {
        return this.myTag;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        if (this.myName == null) {
            this.init((PsiElement)this.myTag);
        }
        return this.myName;
    }

    public void init(PsiElement element) {
        XmlTag tag;
        this.myTag = tag = (XmlTag)element;
        CustomTagSupportUtil.ValueAccessor subTagAccessor = CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR;
        this.myName = subTagAccessor.getValue(tag, NAME_TAG_NAME);
        if (this.myName == null) {
            this.myName = subTagAccessor.getValue(tag, NAME2_TAG_NAME);
            if (this.myName != null) {
                this.myUsedTagName = NAME2_TAG_NAME;
            }
        }
        this.setFunctionSignature(subTagAccessor.getValue(tag, FUNCTION_SIGNATURE));
        this.myFunctionClass = subTagAccessor.getValue(tag, "function-class");
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = new Object[]{this.myTag, ExternalResourceManager.getInstance()};
        if (objectArray == null) {
            FunctionDescriptorImpl.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public void setName(String name) throws IncorrectOperationException {
        CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR.setValue(this.myTag, this.myUsedTagName, name);
        this.myName = null;
    }

    public String getFunctionClass() {
        return this.myFunctionClass;
    }

    public void setFunctionClass(String functionClass) {
        this.myFunctionClass = functionClass;
    }

    public String getFunctionSignature() {
        return this.myFunctionSignature;
    }

    public void setFunctionSignature(String functionSignature) {
        this.myFunctionSignature = functionSignature;
        this.myParameterCount = 0;
        if (functionSignature == null) {
            this.myFunctionSignature = "";
            this.myFunctionReturnType = "";
            this.myFunctionParameters = Collections.emptyList();
            this.myFunctionName = "";
            return;
        }
        String trimmedFunctionSignature = this.myFunctionSignature.trim();
        int ind = functionSignature.indexOf(40);
        int ind2 = functionSignature.indexOf(41, ind);
        String signatureToParse = "";
        if (ind != -1 && ind2 != -1) {
            signatureToParse = this.myFunctionSignature.substring(ind + 1, ind2);
        }
        int returnTypeDelimiterInd = -1;
        for (int i = 0; i < trimmedFunctionSignature.length(); ++i) {
            if (!Character.isWhitespace(trimmedFunctionSignature.charAt(i))) continue;
            returnTypeDelimiterInd = i;
            break;
        }
        int endIndex = trimmedFunctionSignature.indexOf(40, returnTypeDelimiterInd + 1);
        this.myFunctionReturnType = trimmedFunctionSignature.substring(0, returnTypeDelimiterInd != -1 ? returnTypeDelimiterInd : 0);
        this.myFunctionName = endIndex != -1 ? trimmedFunctionSignature.substring(returnTypeDelimiterInd + 1, endIndex) : trimmedFunctionSignature.substring(returnTypeDelimiterInd + 1);
        this.myFunctionName = this.myFunctionName.trim();
        StringTokenizer tokenizer = new StringTokenizer(signatureToParse, " \t,\n\r");
        this.myFunctionParameters = new ArrayList<String>(1);
        while (tokenizer.hasMoreElements()) {
            ++this.myParameterCount;
            this.myFunctionParameters.add((String)tokenizer.nextElement());
        }
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public int getParameterCount() {
        return this.myParameterCount;
    }

    public String getFunctionName() {
        return this.myFunctionName;
    }

    public List<String> getFunctionParameters() {
        return this.myFunctionParameters;
    }

    public String getFunctionReturnType() {
        return this.myFunctionReturnType;
    }

    FunctionDescriptorImpl(XmlTag tag) {
        this.init((PsiElement)tag);
    }

    @Nullable
    public PsiType getResultType() {
        if (this.myFunctionReturnType == null || this.myFunctionReturnType.length() == 0) {
            this.myFunctionPsiType = null;
        } else if (this.myFunctionPsiType == null || !this.myFunctionPsiType.isValid() || !this.myFunctionReturnType.equals(this.myFunctionPsiType.getCanonicalText())) {
            try {
                this.myFunctionPsiType = JavaPsiFacade.getInstance((Project)this.myTag.getProject()).getElementFactory().createTypeFromText(this.myFunctionReturnType, (PsiElement)this.myTag);
            }
            catch (Exception e) {
                this.myFunctionPsiType = PsiType.VOID;
            }
        }
        return this.myFunctionPsiType;
    }

    @Nullable
    public PsiMethod getReferencedMethod() {
        XmlTag subTag = this.myTag.findFirstSubTag(FUNCTION_SIGNATURE);
        if (subTag != null) {
            PsiReference[] references = subTag.getReferences();
            return references.length > 2 && references[references.length - 1] instanceof TaglibReferenceProvider.MethodReference ? (PsiMethod)references[references.length - 1].resolve() : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/impl/FunctionDescriptorImpl", "getDependencies"));
    }
}

