/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.impl.FileSubtypeSpecificDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileSubtypeSpecificElementDescriptor
extends XmlElementDescriptorImpl
implements Validator<XmlTag>,
FileSubtypeSpecificDescriptor {
    private final boolean mySpecificOnlyToTagAndTagxFile;
    private final boolean mySpecificOnlyToJspAndJspxFile;
    private final boolean mySpecificOnlyToXmlSyntax;
    @NonNls
    public static final String TAG_FILE_EXTENSION = "tag";
    @NonNls
    public static final String TAGX_FILE_EXTENSION = "tagx";

    FileSubtypeSpecificElementDescriptor(boolean _specificOnlyToTagAndTagxFile, boolean _specificOnlyToJspAndJspxFile, boolean _specificOnlyToXmlSyntax, PsiElement declaration) {
        super((XmlTag)declaration);
        this.mySpecificOnlyToJspAndJspxFile = _specificOnlyToJspAndJspxFile;
        this.mySpecificOnlyToTagAndTagxFile = _specificOnlyToTagAndTagxFile;
        this.mySpecificOnlyToXmlSyntax = _specificOnlyToXmlSyntax;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            FileSubtypeSpecificElementDescriptor.$$$reportNull$$$0(0);
        }
        if (host == null) {
            FileSubtypeSpecificElementDescriptor.$$$reportNull$$$0(1);
        }
        super.validate(context, host);
        boolean isTagFileSpecificExtension = FileSubtypeSpecificElementDescriptor.isInTagFile((PsiElement)context);
        if (this.mySpecificOnlyToTagAndTagxFile && !isTagFileSpecificExtension || this.mySpecificOnlyToJspAndJspxFile && isTagFileSpecificExtension) {
            String message = this.mySpecificOnlyToTagAndTagxFile ? JavaeeJspBundle.message("tag.should.be.used.in.tag.file.error.message", new Object[0]) : JavaeeJspBundle.message("tag.should.not.be.used.in.tag.file.error.message", new Object[0]);
            host.addMessage((PsiElement)context, message, Validator.ValidationHost.ErrorType.ERROR);
        }
    }

    public static boolean isInTagFile(PsiElement context) {
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        String extension = containingFile.getVirtualFile() != null ? containingFile.getVirtualFile().getExtension() : null;
        return TAG_FILE_EXTENSION.equals(extension) || TAGX_FILE_EXTENSION.equals(extension);
    }

    private static boolean isJspFileSpecific(PsiElement context) {
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        return containingFile.getFileType() == StdFileTypes.JSP;
    }

    @Override
    public boolean isAcceptableInContext(PsiFile file) {
        boolean contextIsJspFile = FileSubtypeSpecificElementDescriptor.isJspFileSpecific((PsiElement)file);
        boolean contextIsJspxFile = file.getFileType() == StdFileTypes.JSPX;
        boolean contextIsTagFile = FileSubtypeSpecificElementDescriptor.isInTagFile((PsiElement)file);
        return this.mySpecificOnlyToJspAndJspxFile && (contextIsJspFile && !this.mySpecificOnlyToXmlSyntax || contextIsJspxFile && this.mySpecificOnlyToXmlSyntax) && !contextIsTagFile || this.mySpecificOnlyToTagAndTagxFile && contextIsTagFile || !this.mySpecificOnlyToTagAndTagxFile && !this.mySpecificOnlyToJspAndJspxFile && this.mySpecificOnlyToXmlSyntax == !contextIsJspFile;
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
        }
        objectArray[1] = "com/intellij/jsp/impl/FileSubtypeSpecificElementDescriptor";
        objectArray[2] = "validate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

