/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.base.JavaeeJspBaseBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.source.jsp.el.impl.MethodSignatureFilter;
import com.intellij.psi.impl.source.jsp.el.impl.StringMethodSignatureFilter;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ElMethodSignatureInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            ElMethodSignatureInspection.$$$reportNull$$$0(0);
        }
        return new ELElementVisitor(){

            @Override
            public void visitELExpressionHolder(ELExpressionHolder expressionHolder) {
                PsiElement[] children = expressionHolder.getChildren();
                if (children.length == 1) {
                    PsiElement child = children[0];
                    if (!(child instanceof ELSelectExpression)) {
                        return;
                    }
                    ELVariable method = ((ELSelectExpression)child).getField();
                    if (method != null) {
                        ElMethodSignatureInspection.checkCallExpression(method, expressionHolder, problemsHolder);
                    }
                }
            }
        };
    }

    private static void checkCallExpression(ELVariable method, ELExpressionHolder elHolder, ProblemsHolder problemsHolder) {
        PsiReference reference = method.getReference();
        if (reference == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiMethod)) {
            return;
        }
        MethodSignatureFilter filter = StringMethodSignatureFilter.getDeferredMethodSignatureFilter(elHolder);
        if (filter != null && !filter.isAcceptable((PsiMethod)element)) {
            String s = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)259, (int)2);
            problemsHolder.registerProblem((PsiElement)method, JavaeeJspBundle.message("method.does.not.match", s, filter.getSignature()), new LocalQuickFix[0]);
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = JavaeeJspBaseBundle.message("jsp.inspections.group.name", new Object[0]);
        if (string == null) {
            ElMethodSignatureInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "ELMethodSignatureInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/jsp/ElMethodSignatureInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/jsp/ElMethodSignatureInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

