/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspSuppressionProvider
extends DefaultXmlSuppressionProvider {
    @Nullable
    private static XmlText getAnchor(PsiElement originalElement) {
        ELExpressionHolder holder;
        BaseJspFile file = BaseJspUtil.getJspFile(originalElement);
        if (file == null) {
            return null;
        }
        if (originalElement instanceof OuterLanguageElement && (holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)originalElement, ELExpressionHolder.class, (boolean)false)) != null) {
            return (XmlText)PsiTreeUtil.getPrevSiblingOfType((PsiElement)(holder.getParent() instanceof XmlTag ? holder : PsiTreeUtil.getParentOfType((PsiElement)holder, XmlTag.class)), XmlText.class);
        }
        if (originalElement.getContainingFile() == file && originalElement instanceof XmlTag && originalElement.getPrevSibling() instanceof XmlText) {
            return (XmlText)originalElement.getPrevSibling();
        }
        JspxFileViewProvider viewProvider = file.getViewProvider();
        PsiElement element = viewProvider.findElementAt(originalElement.getTextOffset(), viewProvider.getBaseLanguage());
        return (XmlText)PsiTreeUtil.getContextOfType((PsiElement)element, XmlText.class, (boolean)false);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String inspectionId) {
        XmlText anchor;
        if (element == null) {
            JspSuppressionProvider.$$$reportNull$$$0(0);
        }
        if (inspectionId == null) {
            JspSuppressionProvider.$$$reportNull$$$0(1);
        }
        if ((anchor = JspSuppressionProvider.getAnchor(element)) != null) {
            return this.findSuppression((PsiElement)anchor, inspectionId, element) != null;
        }
        return this.findFileSuppression(null, inspectionId, element) != null;
    }

    protected PsiElement findSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiElement element = this.findSuppressionLeaf(anchor, id, JspSuppressionProvider.getTopmostOffset(originalElement));
        if (element != null) {
            return element;
        }
        return this.findFileSuppression(anchor, id, originalElement);
    }

    protected PsiElement findFileSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiElement leaf;
        BaseJspFile file = BaseJspUtil.getJspFile(anchor == null ? originalElement : anchor);
        if (file == null) {
            return null;
        }
        XmlTag rootTag = file.getRootTag();
        int offset = JspSuppressionProvider.getFileHeaderOffset(originalElement);
        for (leaf = rootTag.getLastChild(); leaf != null && leaf.getTextOffset() > offset; leaf = leaf.getPrevSibling()) {
        }
        return this.findSuppressionLeaf(leaf, id, 0);
    }

    private static int getFileHeaderOffset(PsiElement originalElement) {
        XmlTag originalRootTag;
        XmlDocument originalDocument;
        PsiFile originalFile = originalElement.getContainingFile();
        if (originalFile instanceof XmlFile && (originalDocument = ((XmlFile)originalFile).getDocument()) != null && (originalRootTag = originalDocument.getRootTag()) != null) {
            return originalRootTag.getTextOffset();
        }
        return 0;
    }

    private static int getTopmostOffset(PsiElement originalElement) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (tag != null) {
            XmlTag prevSibling = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)tag, XmlTag.class);
            if (prevSibling == null) {
                XmlTag parentTag = tag.getParentTag();
                if (parentTag != null) {
                    return parentTag.getTextOffset();
                }
            } else {
                return prevSibling.getTextOffset();
            }
        }
        return 0;
    }

    public void suppressForFile(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            JspSuppressionProvider.$$$reportNull$$$0(2);
        }
        if (inspectionId == null) {
            JspSuppressionProvider.$$$reportNull$$$0(3);
        }
        BaseJspFile file = BaseJspUtil.getJspFile(element);
        assert (file != null);
        XmlTag rootTag = file.getRootTag();
        PsiElement suppression = this.findFileSuppression((PsiElement)rootTag, inspectionId, element);
        this.suppress((PsiFile)file, suppression, inspectionId, rootTag.getTextRange().getStartOffset());
    }

    public void suppressForTag(@NotNull PsiElement element, @NotNull String inspectionId) {
        int offset;
        if (element == null) {
            JspSuppressionProvider.$$$reportNull$$$0(4);
        }
        if (inspectionId == null) {
            JspSuppressionProvider.$$$reportNull$$$0(5);
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null);
        PsiFile file = element.getContainingFile();
        String text = file.getText();
        for (offset = tag.getTextRange().getStartOffset(); offset > 0 && text.charAt(offset - 1) != '\n'; --offset) {
        }
        this.suppress(file, this.findSuppressionLeaf((PsiElement)JspSuppressionProvider.getAnchor(element), null, JspSuppressionProvider.getTopmostOffset(element)), inspectionId, offset);
    }

    protected String getPrefix() {
        return "<%--suppress ";
    }

    protected String getSuffix() {
        return " --%>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/JspSuppressionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressForFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressForTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

