/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspTagNameReference;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspXmlCompletionContributor
extends CompletionContributor {
    public JspXmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(JspDirective.class))).afterLeaf(new String[]{"<%@"}), new JspDirectiveCompletionProvider());
        JspTagNameCompletionProvider provider = new JspTagNameCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlTag()), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(XmlToken.class).andNot((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlTag())), provider);
    }

    private static class JspTagNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private JspTagNameCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiReference reference;
            if (parameters == null) {
                JspTagNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JspTagNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JspTagNameCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset())) instanceof JspTagNameReference) {
                JspTagNameReference jspTagNameReference = (JspTagNameReference)reference;
                if (reference.getElement() instanceof JspDirective) {
                    result.stopHere();
                    return;
                }
                if (!jspTagNameReference.isStartTagFlag()) {
                    JspTagNameCompletionProvider.addJspTagVariants(jspTagNameReference, result);
                }
            }
        }

        private static void addJspTagVariants(JspTagNameReference reference, CompletionResultSet result) {
            XmlTag fromJspTree;
            PsiElement element = reference.getElement();
            if (element instanceof XmlTag) {
                result.addAllElements((Iterable)TagNameReferenceCompletionProvider.createClosingTagLookupElements((XmlTag)((XmlTag)element), (boolean)false, (ASTNode)reference.getNameElement()));
            }
            if ((fromJspTree = JspTagNameCompletionProvider.getJspTag(reference, element)) != null && StringUtil.isNotEmpty((String)fromJspTree.getName())) {
                result.addAllElements((Iterable)TagNameReferenceCompletionProvider.createClosingTagLookupElements((XmlTag)fromJspTree, (boolean)false, (ASTNode)reference.getNameElement()));
            }
        }

        @Nullable
        private static XmlTag getJspTag(JspTagNameReference reference, PsiElement element) {
            XmlTag fromJspTree = null;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile.getViewProvider().getBaseLanguage() == NewJspLanguage.getInstance()) {
                JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)containingFile);
                int startOffset = element.getTextRange().getStartOffset() + reference.getRangeInElement().getStartOffset();
                PsiElement current = jspFile.getDocument().findElementAt(startOffset);
                if (current != element && (current = PsiTreeUtil.getParentOfType((PsiElement)current, XmlText.class)) != null) {
                    fromJspTree = ((XmlText)current).getParentTag();
                    if (XmlChildRole.EMPTY_TAG_END_FINDER.findChild(fromJspTree.getNode()) != null || XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(fromJspTree.getNode()) != null || fromJspTree instanceof JspXmlRootTag) {
                        fromJspTree = null;
                    }
                    while ((current = current.getPrevSibling()) != null) {
                        XmlTag xmlTag;
                        if (!(current instanceof XmlTag) || XmlChildRole.EMPTY_TAG_END_FINDER.findChild((xmlTag = (XmlTag)current).getNode()) != null || XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(xmlTag.getNode()) != null) continue;
                        fromJspTree = xmlTag;
                        break;
                    }
                }
            }
            return fromJspTree;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/JspXmlCompletionContributor$JspTagNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DirectiveInsertHandler
    implements InsertHandler<LookupElement> {
        public static DirectiveInsertHandler INSTANCE = new DirectiveInsertHandler();

        private DirectiveInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                DirectiveInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                DirectiveInsertHandler.$$$reportNull$$$0(1);
            }
            Project project = context.getProject();
            Editor editor = context.getEditor();
            int caretOffset = editor.getCaretModel().getOffset();
            PsiElement currentElement = context.getFile().findElementAt(caretOffset - 1);
            JspDirective tag = (JspDirective)PsiTreeUtil.getParentOfType((PsiElement)currentElement, JspDirective.class);
            XmlElementDescriptor meta = null;
            if (tag == null) {
                return;
            }
            if (item.getObject() instanceof String) {
                String name = (String)item.getObject();
                JspManager jspManager = JspManager.getInstance((Project)project);
                if (jspManager != null) {
                    meta = jspManager.getDirectiveDescriptorByName(name, context.getFile());
                }
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            if (meta != null) {
                TemplateManager templateManager = TemplateManager.getInstance((Project)project);
                Template template = templateManager.createTemplate("", "");
                XmlAttributeDescriptor[] attributes = meta.getAttributesDescriptors((XmlTag)tag);
                XmlAttribute[] existingAttributes = tag.getAttributes();
                block0: for (XmlAttributeDescriptor attribute : attributes) {
                    if (!attribute.isRequired()) continue;
                    for (XmlAttribute existingAttribute : existingAttributes) {
                        if (attribute.getName().equals(existingAttribute.getName())) continue block0;
                    }
                    template.addTextSegment(" ");
                    template.addTextSegment(attribute.getName());
                    template.addTextSegment("=\"");
                    MacroCallNode expression = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
                    template.addVariable(attribute.getName(), (Expression)expression, (Expression)expression, true);
                    template.addTextSegment("\"");
                }
                if (attributes.length > 0) {
                    template.addEndVariable();
                }
                if (DirectiveInsertHandler.getDirectiveEnd((PsiElement)tag) == null) {
                    template.addTextSegment("%>");
                }
                templateManager.startTemplate(editor, template);
            } else if (context.getCompletionChar() == '\t') {
                PsiElement sibling;
                PsiElement endTagStart = DirectiveInsertHandler.getDirectiveEnd((PsiElement)tag);
                if (endTagStart != null && (sibling = endTagStart.getNextSibling()).getNode().getElementType() == XmlTokenType.XML_NAME) {
                    int sOffset = sibling.getTextRange().getStartOffset();
                    int eOffset = sibling.getTextRange().getEndOffset();
                    editor.getDocument().deleteString(sOffset, eOffset);
                    editor.getDocument().insertString(sOffset, (CharSequence)tag.getName());
                }
                editor.getCaretModel().moveToOffset(caretOffset + 1);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
            } else {
                editor.getDocument().insertString(caretOffset, (CharSequence)"%>");
                editor.getCaretModel().moveToOffset(caretOffset + 1);
            }
        }

        @Nullable
        private static PsiElement getDirectiveEnd(PsiElement tag) {
            ASTNode child = tag.getNode().findChildByType(XmlTokenType.XML_EMPTY_ELEMENT_END);
            return child != null ? child.getPsi() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/JspXmlCompletionContributor$DirectiveInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JspDirectiveCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NonNls
        private static final String TAG_FILE_EXTENSION = "tag";
        @NonNls
        private static final String[] TAG_FILE_DIRECTIVES = new String[]{"tag", "taglib", "include", "variable", "attribute"};
        @NonNls
        private static final String[] PAGE_FILE_DIRECTIVES = new String[]{"page", "taglib", "include"};

        private JspDirectiveCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiFile containingFile;
            VirtualFile virtualFile;
            String[] directives;
            if (parameters == null) {
                JspDirectiveCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JspDirectiveCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JspDirectiveCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String directive : directives = (virtualFile = (containingFile = parameters.getOriginalFile()).getVirtualFile()) != null && TAG_FILE_EXTENSION.equals(virtualFile.getExtension()) ? TAG_FILE_DIRECTIVES : PAGE_FILE_DIRECTIVES) {
                result.consume((LookupElement)LookupElementBuilder.create((String)directive).withInsertHandler((InsertHandler)DirectiveInsertHandler.INSTANCE));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/JspXmlCompletionContributor$JspDirectiveCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

