/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ELFunctionInsertHandler;
import com.intellij.codeInsight.completion.ExtendedELFunctionInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JspCompletionContributor
extends CompletionContributor {
    private static final String[] EL_KEYWORDS = new String[]{"and", "or", "not", "empty", "eq", "ne", "gt", "lt", "le", "ge", "true", "false", "null", "empty", "div", "mod"};
    private static final InsertHandler EL_INSERT_HANDLER = new ELFunctionInsertHandler();

    public JspCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withLanguage(ELLanguage.INSTANCE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement prev;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!JspCompletionContributor.inReference(prev = PsiTreeUtil.prevLeaf((PsiElement)parameters.getPosition())) && PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), ELVariable.class, (boolean)false) != null) {
                    for (String keyword : EL_KEYWORDS) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).withInsertHandler(EL_INSERT_HANDLER));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/JspCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean inReference(PsiElement prev) {
        if (prev == null) {
            return false;
        }
        return prev.textMatches((CharSequence)".") || prev.textMatches((CharSequence)"[") || prev.textMatches((CharSequence)":");
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            JspCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JspCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result);
        ASTNode node = parameters.getPosition().getNode();
        if (parameters.isExtendedCompletion() && node != null && node.getElementType() == ELTokenType.JSP_EL_IDENTIFIER) {
            result.stopHere();
            PsiElement element = parameters.getPosition();
            PsiElement parent = element.getParent();
            if (parent != null) {
                ELVariable namespace;
                PsiElement call = parent.getParent();
                String namespacePrefix = call instanceof ELFunctionCallExpression ? ((namespace = (ELVariable)ReadAction.compute(() -> ((ELFunctionCallExpression)call).getNamespace())) == null ? null : namespace.getText()) : null;
                JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)call);
                if (jspFile == null) {
                    return;
                }
                List names = (List)ReadAction.compute(() -> JspManager.getInstance((Project)element.getProject()).getAvailableFunctions(jspFile));
                for (Pair pair : names) {
                    String name = (String)pair.getFirst();
                    if (!result.getPrefixMatcher().prefixMatches(name)) continue;
                    LookupItem item = LookupItem.fromString((String)name);
                    String ns = (String)pair.getSecond();
                    ExtendedELFunctionInsertHandler insertHandler = new ExtendedELFunctionInsertHandler(name, ns, namespacePrefix);
                    if (!StringUtil.isEmpty((String)ns)) {
                        item.setAttribute(LookupItem.TAIL_TEXT_ATTR, (Object)(" (" + ns + ")"));
                        item.setAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR, (Object)"");
                    }
                    item.setInsertHandler((InsertHandler)insertHandler);
                    result.addElement((LookupElement)item);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/JspCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

