/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.FileTimestampStorage;
import org.jetbrains.jps.incremental.storage.MurmurHashingService;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.jps.incremental.storage.StampsStorage;

public class FileStampStorage
extends AbstractStateStorage<String, HashStampPerTarget[]>
implements StampsStorage<FileStamp> {
    private final FileTimestampStorage myTimestampStorage;
    private final PathRelativizerService myRelativizer;
    private final BuildTargetsState myTargetsState;
    private final File myFileStampRoot;

    public FileStampStorage(File dataStorageRoot, PathRelativizerService relativizer, BuildTargetsState targetsState) throws IOException {
        super(new File(FileStampStorage.calcStorageRoot(dataStorageRoot), "data"), PathStringDescriptor.INSTANCE, new StateExternalizer());
        this.myTimestampStorage = new FileTimestampStorage(dataStorageRoot, targetsState);
        this.myFileStampRoot = FileStampStorage.calcStorageRoot(dataStorageRoot);
        this.myRelativizer = relativizer;
        this.myTargetsState = targetsState;
    }

    @NotNull
    private String relativePath(@NotNull File file) {
        if (file == null) {
            FileStampStorage.$$$reportNull$$$0(0);
        }
        String string = this.myRelativizer.toRelative(file.getAbsolutePath());
        if (string == null) {
            FileStampStorage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static File calcStorageRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, "hashes");
    }

    @Override
    public File getStorageRoot() {
        return this.myFileStampRoot;
    }

    @Override
    public void saveStamp(File file, BuildTarget<?> buildTarget, FileStamp stamp) throws IOException {
        this.myTimestampStorage.saveStamp(file, buildTarget, FileTimestampStorage.Timestamp.fromLong(stamp.myTimestamp));
        int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
        String path = this.relativePath(file);
        this.update(path, FileStampStorage.updateFilesStamp((HashStampPerTarget[])this.getState(path), targetId, stamp));
    }

    private static HashStampPerTarget @NotNull [] updateFilesStamp(HashStampPerTarget[] oldState, int targetId, FileStamp stamp) {
        HashStampPerTarget newItem = new HashStampPerTarget(targetId, stamp.myBytes);
        if (oldState == null) {
            HashStampPerTarget[] hashStampPerTargetArray = new HashStampPerTarget[]{newItem};
            if (hashStampPerTargetArray == null) {
                FileStampStorage.$$$reportNull$$$0(2);
            }
            return hashStampPerTargetArray;
        }
        int length = oldState.length;
        for (int i = 0; i < length; ++i) {
            if (oldState[i].targetId != targetId) continue;
            oldState[i] = newItem;
            if (oldState == null) {
                FileStampStorage.$$$reportNull$$$0(3);
            }
            return oldState;
        }
        HashStampPerTarget[] hashStampPerTargetArray = (HashStampPerTarget[])ArrayUtil.append((Object[])oldState, (Object)newItem);
        if (hashStampPerTargetArray == null) {
            FileStampStorage.$$$reportNull$$$0(4);
        }
        return hashStampPerTargetArray;
    }

    @Override
    public void removeStamp(File file, BuildTarget<?> buildTarget) throws IOException {
        this.myTimestampStorage.removeStamp(file, buildTarget);
        String path = this.relativePath(file);
        Object[] state = (HashStampPerTarget[])this.getState(path);
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(buildTarget);
            for (int i = 0; i < state.length; ++i) {
                if (state[i].targetId != targetId) continue;
                if (state.length == 1) {
                    this.remove(path);
                    continue;
                }
                HashStampPerTarget[] newState = (HashStampPerTarget[])ArrayUtil.remove((Object[])state, (int)i);
                this.update(path, newState);
                break;
            }
        }
    }

    @Override
    public FileStamp getPreviousStamp(File file, BuildTarget<?> target) throws IOException {
        StampsStorage.Stamp previousTimestamp = this.myTimestampStorage.getPreviousStamp(file, (BuildTarget)target);
        HashStampPerTarget[] state = (HashStampPerTarget[])this.getState(this.relativePath(file));
        if (state != null) {
            int targetId = this.myTargetsState.getBuildTargetId(target);
            for (HashStampPerTarget filesStampPerTarget : state) {
                if (filesStampPerTarget.targetId != targetId) continue;
                return new FileStamp(filesStampPerTarget.hash, ((FileTimestampStorage.Timestamp)previousTimestamp).asLong());
            }
        }
        return FileStamp.EMPTY;
    }

    public byte @Nullable [] getStoredFileHash(File file, BuildTarget<?> target) throws IOException {
        HashStampPerTarget[] state = (HashStampPerTarget[])this.getState(this.relativePath(file));
        if (state == null) {
            return null;
        }
        int targetId = this.myTargetsState.getBuildTargetId(target);
        for (HashStampPerTarget filesStampPerTarget : state) {
            if (filesStampPerTarget.targetId != targetId) continue;
            return filesStampPerTarget.hash;
        }
        return null;
    }

    @Override
    public FileStamp getCurrentStamp(File file) throws IOException {
        FileTimestampStorage.Timestamp currentTimestamp = this.myTimestampStorage.getCurrentStamp(file);
        return new FileStamp(MurmurHashingService.getFileHash(file), currentTimestamp.asLong());
    }

    @Override
    public boolean isDirtyStamp(@NotNull StampsStorage.Stamp stamp, File file) throws IOException {
        if (stamp == null) {
            FileStampStorage.$$$reportNull$$$0(5);
        }
        if (!(stamp instanceof FileStamp)) {
            return true;
        }
        FileStamp filesStamp = (FileStamp)stamp;
        if (!this.myTimestampStorage.isDirtyStamp(FileTimestampStorage.Timestamp.fromLong(filesStamp.myTimestamp), file)) {
            return false;
        }
        return !Arrays.equals(filesStamp.myBytes, MurmurHashingService.getFileHash(file));
    }

    @Override
    public boolean isDirtyStamp(StampsStorage.Stamp stamp, File file, @NotNull BasicFileAttributes attrs) throws IOException {
        if (attrs == null) {
            FileStampStorage.$$$reportNull$$$0(6);
        }
        if (!(stamp instanceof FileStamp)) {
            return true;
        }
        FileStamp filesStamp = (FileStamp)stamp;
        if (!this.myTimestampStorage.isDirtyStamp(FileTimestampStorage.Timestamp.fromLong(filesStamp.myTimestamp), file, attrs)) {
            return false;
        }
        return !Arrays.equals(filesStamp.myBytes, MurmurHashingService.getFileHash(file));
    }

    @Override
    public void force() {
        super.force();
        this.myTimestampStorage.force();
    }

    @Override
    public void clean() throws IOException {
        super.clean();
        this.myTimestampStorage.clean();
    }

    @Override
    public boolean wipe() {
        return super.wipe() && this.myTimestampStorage.wipe();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.myTimestampStorage.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/FileStampStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stamp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/FileStampStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFilesStamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirtyStamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StateExternalizer
    implements DataExternalizer<HashStampPerTarget[]> {
        private StateExternalizer() {
        }

        public void save(@NotNull DataOutput out, HashStampPerTarget[] value) throws IOException {
            if (out == null) {
                StateExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.length);
            for (HashStampPerTarget target : value) {
                out.writeInt(target.targetId);
                out.write(target.hash);
            }
        }

        public HashStampPerTarget[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                StateExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            HashStampPerTarget[] targets = new HashStampPerTarget[size];
            for (int i = 0; i < size; ++i) {
                int id = in.readInt();
                byte[] bytes = new byte[16];
                in.readFully(bytes);
                targets[i] = new HashStampPerTarget(id, bytes);
            }
            return targets;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/FileStampStorage$StateExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class FileStamp
    implements StampsStorage.Stamp {
        static FileStamp EMPTY = new FileStamp(new byte[0], -1L);
        private final byte[] myBytes;
        private final long myTimestamp;

        private FileStamp(byte[] bytes, long timestamp) {
            this.myBytes = bytes;
            this.myTimestamp = timestamp;
        }

        public String toString() {
            return "FileStamp{myBytes=" + Arrays.toString(this.myBytes) + ", myTimestamp=" + this.myTimestamp + '}';
        }
    }

    static final class HashStampPerTarget {
        public final int targetId;
        public final byte[] hash;

        private HashStampPerTarget(int targetId, byte[] hash) {
            this.targetId = targetId;
            this.hash = hash;
        }
    }
}

