/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import java.util.concurrent.Future;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.PreloadedDataExtension;
import org.jetbrains.jps.cmdline.PreloadedData;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.service.JpsServiceManager;

public class CleanupTempDirectoryExtension
implements PreloadedDataExtension {
    private Future<Void> myTask;

    @Override
    public void preloadData(PreloadedData data) {
        ProjectDescriptor pd = data.getProjectDescriptor();
        if (pd != null) {
            this.myTask = IncProjectBuilder.startTempDirectoryCleanupTask(pd);
        }
    }

    @Nullable
    public static CleanupTempDirectoryExtension getInstance() {
        for (PreloadedDataExtension extension : JpsServiceManager.getInstance().getExtensions(PreloadedDataExtension.class)) {
            if (!(extension instanceof CleanupTempDirectoryExtension)) continue;
            return (CleanupTempDirectoryExtension)extension;
        }
        return null;
    }

    @Nullable
    public Future<Void> getCleanupTask() {
        return this.myTask;
    }

    @Override
    public void buildSessionInitialized(PreloadedData data) {
    }

    @Override
    public void discardPreloadedData(PreloadedData data) {
    }
}

