/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl;

import com.intellij.DynamicBundle;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.wsl.WSLBundle;
import com.intellij.wsl.WSLCredentialsHolder;
import com.intellij.wsl.WSLCredentialsType;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLCredentialsEditor
implements CredentialsEditor<WSLCredentialsHolder>,
PanelWithAnchor {
    private final CollectionComboBoxModel<WSLDistribution> myComboBoxModel;
    private ComboBox<WSLDistribution> myComboBox;
    private JPanel myPanel;
    private JBLabel myLabel;
    @Nullable
    private JComponent myAnchor;

    public WSLCredentialsEditor() {
        this.$$$setupUI$$$();
        List distributions = WSLUtil.getAvailableDistributions();
        distributions.sort(Comparator.comparing(WSLDistribution::getPresentableName));
        this.myComboBoxModel = new CollectionComboBoxModel(distributions);
        this.myComboBox.setModel(this.myComboBoxModel);
        this.myComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", WSLDistribution::getPresentableName));
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = WSLCredentialsType.getInstance().getName();
        if (string == null) {
            WSLCredentialsEditor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JPanel getMainPanel() {
        return this.myPanel;
    }

    public void onSelected() {
    }

    public ValidationInfo validate() {
        if (this.myComboBoxModel.getSelected() == null) {
            return new ValidationInfo(WSLBundle.message("dialog.message.please.select.distribution", new Object[0]), this.myComboBox);
        }
        return null;
    }

    @NlsContexts.DialogMessage
    public String validateFinal(@NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier, @NotNull Consumer<String> helpersPathUpdateCallback) {
        if (supplier == null) {
            WSLCredentialsEditor.$$$reportNull$$$0(1);
        }
        if (helpersPathUpdateCallback == null) {
            WSLCredentialsEditor.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void saveCredentials(WSLCredentialsHolder credentials) {
        WSLDistribution selectedItem = this.getWslDistribution();
        if (selectedItem == null) {
            throw new RuntimeException("Saving invalid credentials");
        }
        credentials.setDistributionId(selectedItem.getId());
    }

    @Nullable
    public WSLDistribution getWslDistribution() {
        return (WSLDistribution)this.myComboBoxModel.getSelected();
    }

    public void init(WSLCredentialsHolder credentials) {
        this.myComboBoxModel.setSelectedItem((Object)WSLUtil.getDistributionById((String)credentials.getDistributionId()));
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/WSLCredentialsEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPathUpdateCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/WSLCredentialsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateFinal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        ComboBox comboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/WSLBundle", WSLCredentialsEditor.class).getString("combobox.label.linux.distribution"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

