/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.css.codeStyle.CssLanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.settings.LESSCodeStylePanel;
import org.jetbrains.plugins.less.settings.LessCodeStyleSettings;

public class LESSLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        LESSLanguage lESSLanguage = LESSLanguage.INSTANCE;
        if (lESSLanguage == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return lESSLanguage;
    }

    public CodeStyleGroup getGroup() {
        return CssLanguageCodeStyleSettingsProvider.STYLESHEET_GROUP;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return "@base: #f938ab;\n\n.box-shadow(@style, @c) when (iscolor(@c)) {\n  box-shadow:         @style @c;\n  -webkit-box-shadow: @style @c;\n  -moz-box-shadow:    @style @c;\n}\n.box-shadow(@style, @alpha: 50%) when (isnumber(@alpha)) {\n  .box-shadow(@style, rgba(0, 0, 0, @alpha));\n}\n.box { \n  color: saturate(@base, 5%);\n  border-color: lighten(@base, 30%);\n  div { .box-shadow(0 0 5px, 30%) }\n}";
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        indentOptions.INDENT_SIZE = 2;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new LessCodeStyleSettings(settings);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settingsType == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            CssLanguageCodeStyleSettingsProvider.customizeStyleSheetBlankLinesSettings((CodeStyleSettingsCustomizable)consumer, LessCodeStyleSettings.class);
        }
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (modelSettings == null) {
            LESSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return new CodeStyleAbstractConfigurable(baseSettings, modelSettings, this.getConfigurableDisplayName()){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new LESSCodeStylePanel(this.getCurrentSettings(), settings);
            }

            @NotNull
            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.less";
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/settings/LESSLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/settings/LESSLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

