/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.setup;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.AjIdeaCompiler;
import com.intellij.lang.aspectj.build.config.AjBuildProcessParametersProvider;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjIdeaCompilerSettings;
import com.intellij.lang.aspectj.setup.AjMavenImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenCompilerExtension;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/aspectj/setup/AjMavenCompilerExtension;", "Lorg/jetbrains/idea/maven/importing/MavenCompilerExtension;", "()V", "findCompiler", "", "dependencies", "", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "getCompiler", "Lcom/intellij/compiler/impl/javaCompiler/BackendCompiler;", "project", "Lcom/intellij/openapi/project/Project;", "getMavenCompilerId", "resolveDefaultCompiler", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "nativeMavenProject", "Lorg/jetbrains/idea/maven/server/NativeMavenProjectHolder;", "embedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "context", "Lorg/jetbrains/idea/maven/project/ResolveContext;", "updateCompilerOptions", "", "path", "intellij.aspectj"})
public final class AjMavenCompilerExtension
implements MavenCompilerExtension {
    @NotNull
    public String getMavenCompilerId() {
        return "aspectj";
    }

    @Nullable
    public BackendCompiler getCompiler(@NotNull Project project) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
            if (compilerConfiguration == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
            }
            CompilerConfigurationImpl compilerConfiguration2 = (CompilerConfigurationImpl)compilerConfiguration;
            Collection collection = compilerConfiguration2.getRegisteredJavaCompilers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"compilerConfiguration.registeredJavaCompilers");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                BackendCompiler it = (BackendCompiler)t;
                boolean bl3 = false;
                if (!(it instanceof AjIdeaCompiler)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    public boolean resolveDefaultCompiler(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull NativeMavenProjectHolder nativeMavenProject, @NotNull MavenEmbedderWrapper embedder, @NotNull ResolveContext context) throws MavenProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)nativeMavenProject, (String)"nativeMavenProject");
        Intrinsics.checkNotNullParameter((Object)embedder, (String)"embedder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MavenPlugin plugin = AjMavenImporter.findActivePlugin(mavenProject);
        if (plugin != null) {
            Collection collection = embedder.resolvePlugin(plugin, mavenProject.getRemoteRepositories(), nativeMavenProject, true);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"embedder.resolvePlugin(p\u2026nativeMavenProject, true)");
            String path = this.findCompiler(collection);
            if (path != null) {
                this.updateCompilerOptions(project, path);
                return true;
            }
            AjMavenImporter.warn(AspectJBundle.message("maven.importer.no.dependency", mavenProject.getPath()), project);
        }
        return false;
    }

    private final String findCompiler(Collection<? extends MavenArtifact> dependencies) {
        MavenArtifact compiler = null;
        for (MavenArtifact mavenArtifact : dependencies) {
            String string = mavenArtifact.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.artifactId");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"tools", (boolean)false, (int)2, null)) continue;
            File file = mavenArtifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dependency.file");
            if (!AjBuildProcessParametersProvider.checkCompilerJar(file.getPath()) || compiler != null && StringUtil.compareVersionNumbers((String)mavenArtifact.getVersion(), (String)compiler.getVersion()) <= 0) continue;
            compiler = mavenArtifact;
        }
        Object object = compiler;
        return object != null && (object = object.getFile()) != null ? ((File)object).getPath() : null;
    }

    private final void updateCompilerOptions(Project project, String path) {
        AjCompilerSettings ajCompilerSettings = AjIdeaCompilerSettings.getSettings(project);
        Intrinsics.checkNotNullExpressionValue((Object)ajCompilerSettings, (String)"AjIdeaCompilerSettings.getSettings(project)");
        AjCompilerSettings ajcSettings = ajCompilerSettings;
        ajcSettings.ajcPath = FileUtil.toSystemIndependentName((String)path);
        ajcSettings.delegateToJavac = true;
    }
}

