/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.move;

import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveJavaMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAjMemberHandler
extends MoveJavaMemberHandler {
    private static final Logger LOG = Logger.getInstance(MoveAjMemberHandler.class);

    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(1);
        }
        if (membersToMove == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(3);
        }
        if (member instanceof PsiInterTypeDeclaration) {
            PsiClass containingClass;
            if (member instanceof PsiMethod && MoveAjMemberHandler.hasMethod((PsiClass)targetClass, (PsiMethod)((PsiMethod)member)) || member instanceof PsiField && MoveAjMemberHandler.hasField((PsiClass)targetClass, (PsiField)((PsiField)member))) {
                String message = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                conflicts.putValue((Object)member, (Object)StringUtil.capitalize((String)message));
            }
            PsiClass context = targetClass;
            if (targetClass instanceof PsiAspect && ((PsiAspect)targetClass).isPrivileged() && (containingClass = member.getContainingClass()) != null) {
                context = containingClass;
            }
            RefactoringConflictsUtil.checkUsedElements((PsiMember)member, (PsiElement)member, membersToMove, null, (PsiClass)targetClass, (PsiElement)context, conflicts);
            return;
        }
        super.checkConflictsOnMember(member, newVisibility, modifierListCopy, targetClass, membersToMove, conflicts);
    }

    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiElement copy;
        if (options == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(4);
        }
        if (member == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(5);
        }
        if (targetClass == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(6);
        }
        if (!(member instanceof PsiInterTypeDeclaration)) {
            PsiMember psiMember = super.doMove(options, member, anchor, targetClass);
            if (psiMember == null) {
                MoveAjMemberHandler.$$$reportNull$$$0(7);
            }
            return psiMember;
        }
        if (targetClass instanceof PsiAspect) {
            copy = member.copy();
        } else {
            PsiElement point;
            StringBuilder builder = new StringBuilder();
            builder.append(member.getText());
            PsiInterTypeReference ref = ((PsiInterTypeDeclaration)member).getInterTypeReference();
            for (point = ref.getNextSibling(); point != null && !PsiUtil.isJavaToken((PsiElement)point, (IElementType)JavaTokenType.DOT); point = point.getNextSibling()) {
            }
            assert (point != null) : member;
            if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
                PsiElement newKw;
                for (newKw = point.getNextSibling(); newKw != null && !PsiUtil.isJavaToken((PsiElement)newKw, (IElementType)JavaTokenType.NEW_KEYWORD); newKw = newKw.getNextSibling()) {
                }
                assert (newKw != null) : member;
                builder.replace(newKw.getStartOffsetInParent(), newKw.getStartOffsetInParent() + newKw.getTextLength(), member.getName());
            }
            builder.delete(ref.getStartOffsetInParent(), point.getStartOffsetInParent() + 1);
            String text = builder.toString();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)member.getProject());
            if (member instanceof PsiClass) {
                PsiClass original = (PsiClass)member;
                PsiClass newClass = factory.createClassFromText(text, (PsiElement)original).getInnerClasses()[0];
                MoveAjMemberHandler.replace(newClass.getModifierList(), original.getModifierList());
                MoveAjMemberHandler.replace(newClass.getTypeParameterList(), original.getTypeParameterList());
                MoveAjMemberHandler.replace(newClass.getExtendsList(), original.getExtendsList());
                MoveAjMemberHandler.replace(newClass.getImplementsList(), original.getImplementsList());
                newClass.deleteChildRange(newClass.getLBrace(), newClass.getRBrace());
                newClass.addRange(original.getLBrace(), original.getRBrace());
                copy = newClass;
            } else if (member instanceof PsiField) {
                PsiField original = (PsiField)member;
                PsiField newField = factory.createFieldFromText(text, (PsiElement)original);
                MoveAjMemberHandler.replace(newField.getModifierList(), original.getModifierList());
                MoveAjMemberHandler.replace(newField.getTypeElement(), MoveAjMemberHandler.getRealTypeElement(original.getTypeElement(), factory));
                MoveAjMemberHandler.replace(newField.getInitializer(), original.getInitializer());
                copy = newField;
            } else if (member instanceof PsiMethod) {
                PsiMethod original = (PsiMethod)member;
                PsiMethod newMethod = factory.createMethodFromText(text, (PsiElement)original);
                MoveAjMemberHandler.replace(newMethod.getModifierList(), original.getModifierList());
                MoveAjMemberHandler.replace(newMethod.getTypeParameterList(), original.getTypeParameterList());
                MoveAjMemberHandler.replace(newMethod.getReturnTypeElement(), MoveAjMemberHandler.getRealTypeElement(original.getReturnTypeElement(), factory));
                MoveAjMemberHandler.replace(newMethod.getParameterList(), original.getParameterList());
                MoveAjMemberHandler.replace(newMethod.getThrowsList(), original.getThrowsList());
                MoveAjMemberHandler.replace(newMethod.getBody(), original.getBody());
                copy = newMethod;
            } else {
                LOG.error("Unexpected element: " + member);
                if (null == null) {
                    MoveAjMemberHandler.$$$reportNull$$$0(8);
                }
                return null;
            }
        }
        PsiMember newMember = (PsiMember)(anchor != null ? targetClass.addAfter(copy, anchor) : targetClass.add(copy));
        member.delete();
        PsiMember psiMember = newMember;
        if (psiMember == null) {
            MoveAjMemberHandler.$$$reportNull$$$0(9);
        }
        return psiMember;
    }

    private static <T extends PsiElement> void replace(@Nullable T newElement, @Nullable T originalElement) {
        if (newElement != null && originalElement != null) {
            newElement.replace(originalElement.copy());
        }
    }

    @Nullable
    private static PsiTypeElement getRealTypeElement(PsiTypeElement original, PsiElementFactory factory) {
        PsiClass aClass;
        PsiType originalType;
        if (original != null && (originalType = original.getType()) instanceof PsiClassReferenceType && (aClass = ((PsiClassReferenceType)originalType).resolve()) instanceof InterTypeResolveUtil.TypeParameterReference) {
            PsiTypeParameter realType = ((InterTypeResolveUtil.TypeParameterReference)aClass).getDelegate();
            return factory.createTypeElementFromText(realType.getText(), null);
        }
        return original;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doMove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictsOnMember";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

