/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.util;

import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InterTypeResolveUtil {
    private InterTypeResolveUtil() {
    }

    public static boolean processDeclarationsInInterType(PsiInterTypeDeclaration element, PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiInterTypeReference reference;
        PsiClass target;
        PsiAspect aspect;
        if (state == null) {
            InterTypeResolveUtil.$$$reportNull$$$0(0);
        }
        if (!(element.getParent() instanceof JavaDummyHolder) && !(aspect = element.getAspect()).processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && (target = (reference = element.getInterTypeReference()).getReferencedClass()) != null) {
            String name;
            Pair<Integer, PsiTypeElement> result;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if (nameHint != null && (result = InterTypeResolveUtil.findTypeReferenceByName(reference, name = nameHint.getName(state))) != null && !InterTypeResolveUtil.resolveToClassTypeParameter(target, (Integer)result.first, processor, state, name)) {
                return false;
            }
            PsiTypeParameterList typeParams = target.getTypeParameterList();
            if (typeParams != null && !typeParams.processDeclarations(processor, ResolveState.initial(), lastParent, place)) {
                return false;
            }
        }
        if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            return element.getContainingFile().processDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Nullable
    public static Pair<Integer, PsiTypeElement> findTypeReferenceByName(PsiInterTypeReference reference, String name) {
        PsiReferenceParameterList parameterList = reference.getReferenceElement().getParameterList();
        if (parameterList != null) {
            PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
            for (int i = 0; i < typeParameterElements.length; ++i) {
                PsiTypeElement typeRef = typeParameterElements[i];
                if (!typeRef.getText().equals(name)) continue;
                return Pair.create((Object)i, (Object)typeRef);
            }
        }
        return null;
    }

    public static boolean resolveToClassTypeParameter(PsiClass target, int idx, PsiScopeProcessor processor, ResolveState state, String name) {
        PsiTypeParameter[] classParams = target.getTypeParameters();
        if (idx < classParams.length) {
            TypeParameterReference classParamWrapper = new TypeParameterReference(classParams[idx], name);
            return processor.execute((PsiElement)classParamWrapper, state);
        }
        return true;
    }

    public static PsiMethod createArtificialMethod(String text, PsiClass context) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        LightMethod method = new LightMethod(context.getManager(), factory.createMethodFromText(text, (PsiElement)context), context);
        method.setNavigationElement((PsiElement)context);
        return method;
    }

    public static PsiField createArtificialField(String text, PsiClass context) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        LightField field = new LightField(context.getManager(), factory.createFieldFromText(text, (PsiElement)context), context);
        field.setNavigationElement((PsiElement)context);
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/aspectj/psi/util/InterTypeResolveUtil", "processDeclarationsInInterType"));
    }

    public static class TypeParameterReference
    extends LightTypeParameter {
        private final String myName;

        public TypeParameterReference(PsiTypeParameter delegate, String name) {
            super(delegate);
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                TypeParameterReference.$$$reportNull$$$0(0);
            }
            return this;
        }

        @NotNull
        public PsiElement copy() {
            return new TypeParameterReference(this.getDelegate(), this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/aspectj/psi/util/InterTypeResolveUtil$TypeParameterReference", "setName"));
        }
    }
}

