/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub.impl;

import com.intellij.lang.aspectj.parsing.AspectJStubElementTypes;
import com.intellij.lang.aspectj.psi.stub.PsiInterTypeMethodStub;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.stubs.StubElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiInterTypeMethodStubImpl
extends StubBaseWithFlags<PsiMethod>
implements PsiInterTypeMethodStub {
    private final String myClassName;
    private final String myName;
    private final TypeInfo myReturnType;

    public PsiInterTypeMethodStubImpl(StubElement parent, String className, String name, TypeInfo returnType, byte flags) {
        super(parent, AspectJStubElementTypes.INTER_TYPE_METHOD, flags);
        this.myClassName = className;
        this.myName = name;
        this.myReturnType = returnType;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    public String getName() {
        return this.myName;
    }

    public String getDefaultValueText() {
        return null;
    }

    @NotNull
    public TypeInfo getReturnTypeText(boolean doResolve) {
        TypeInfo typeInfo = this.myReturnType;
        if (typeInfo == null) {
            PsiInterTypeMethodStubImpl.$$$reportNull$$$0(0);
        }
        return typeInfo;
    }

    public boolean isConstructor() {
        return this.isSet(StubBaseWithFlags.Flag.CONSTRUCTOR);
    }

    public boolean isVarArgs() {
        return this.isSet(StubBaseWithFlags.Flag.VAR_ARGS);
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isDeprecated() {
        return this.isSet(StubBaseWithFlags.Flag.DEPRECATED);
    }

    public boolean hasDeprecatedAnnotation() {
        return this.isSet(StubBaseWithFlags.Flag.DEPRECATED_ANNOTATION);
    }

    public PsiParameterStub findParameter(int idx) {
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiParameterListStub)) continue;
            PsiParameterListStub list = (PsiParameterListStub)child;
            List params = list.getChildrenStubs();
            return (PsiParameterStub)params.get(idx);
        }
        throw new RuntimeException("No parameter(s) [yet?]");
    }

    public String toString() {
        return "PsiInterTypeMethodStub[" + this.getFlags() + ":" + this.myClassName + "." + this.myName + ":" + this.myReturnType.text + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/impl/PsiInterTypeMethodStubImpl", "getReturnTypeText"));
    }
}

