/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.index.stub.AjInterTypeClassIndex;
import com.intellij.lang.aspectj.index.stub.AjShortClassNameIndex;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.parsing.AspectJStubElementTypes;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.lang.aspectj.psi.impl.PsiInterTypeClassImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiInterTypeClassStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiInterTypeClassStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ClassElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class AjClassElementType
extends AjStubElementType<PsiInterTypeClassStub, PsiInterTypeClass> {
    public AjClassElementType() {
        super("INTER_TYPE_CLASS");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new ClassElement(AspectJStubElementTypes.INTER_TYPE_CLASS);
    }

    public PsiInterTypeClass createPsi(@NotNull PsiInterTypeClassStub stub) {
        if (stub == null) {
            AjClassElementType.$$$reportNull$$$0(0);
        }
        return new PsiInterTypeClassImpl(stub);
    }

    @Override
    public PsiInterTypeClass createPsi(ASTNode node) {
        return new PsiInterTypeClassImpl(node);
    }

    @NotNull
    public PsiInterTypeClassStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        if (tree == null) {
            AjClassElementType.$$$reportNull$$$0(1);
        }
        if (node == null) {
            AjClassElementType.$$$reportNull$$$0(2);
        }
        if (parentStub == null) {
            AjClassElementType.$$$reportNull$$$0(3);
        }
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String className = null;
        String name = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == AspectJElementType.INTER_TYPE_REFERENCE) {
                className = AjClassElementType.getReferencedClassName(tree, child);
                continue;
            }
            if (type != JavaTokenType.IDENTIFIER) continue;
            name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
        }
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiInterTypeClassStubImpl(parentStub, className, name, flags);
    }

    public void serialize(@NotNull PsiInterTypeClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            AjClassElementType.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            AjClassElementType.$$$reportNull$$$0(5);
        }
        dataStream.writeName(stub.getClassName());
        dataStream.writeName(stub.getName());
        dataStream.writeByte((int)((PsiInterTypeClassStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiInterTypeClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            AjClassElementType.$$$reportNull$$$0(6);
        }
        String className = dataStream.readNameString();
        String name = dataStream.readNameString();
        byte flags = dataStream.readByte();
        return new PsiInterTypeClassStubImpl(parentStub, className, name, flags);
    }

    public void indexStub(@NotNull PsiInterTypeClassStub stub, @NotNull IndexSink sink) {
        String className;
        String name;
        if (stub == null) {
            AjClassElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            AjClassElementType.$$$reportNull$$$0(8);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name);
            sink.occurrence(AjShortClassNameIndex.KEY, (Object)name);
        }
        if ((className = stub.getClassName()) != null) {
            sink.occurrence(AjInterTypeClassIndex.KEY, (Object)className);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/aspectj/psi/stub/AjClassElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

