/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.presentation;

import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.navigation.DelegatingItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.VisibilityIcons;
import icons.AspectjIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class AjPresentationUtil {
    private AjPresentationUtil() {
    }

    public static Icon getAspectIcon(PsiAspect aspect, int flags) {
        Icon base = AjPresentationUtil.getBaseAspectIcon(aspect);
        boolean isLocked = (flags & 2) != 0 && !aspect.isWritable();
        RowIcon rowIcon = IconManager.getInstance().createLayeredIcon((Iconable)aspect, base, ElementPresentationUtil.getFlags((PsiModifierListOwner)aspect, (boolean)isLocked));
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)aspect.getModifierList(), (RowIcon)rowIcon);
        }
        return rowIcon;
    }

    private static Icon getBaseAspectIcon(PsiAspect aspect) {
        PsiModifierList modList = aspect.getModifierList();
        boolean isAbstract = modList != null && modList.hasModifierProperty("abstract");
        return isAbstract ? AspectjIcons.AbstractAspect : AspectjIcons.Aspect;
    }

    public static ItemPresentation getInterTypeItemPresentation(PsiInterTypeDeclaration element, ItemPresentation original) {
        return new DelegatingItemPresentation(original).withLocationString(AjPresentationUtil.getAspectMemberLocation(element));
    }

    @Nullable
    private static String getAspectMemberLocation(PsiInterTypeDeclaration element) {
        String qName = element.getAspect().getQualifiedName();
        return qName != null ? AspectJBundle.message("item.presentation.location", qName) : null;
    }
}

