/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.aspectj.parsing.AspectJStubElementTypes;
import com.intellij.lang.aspectj.parsing.AspectJTokenType;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.presentation.AjPresentationUtil;
import com.intellij.lang.aspectj.psi.stub.PsiAspectStub;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAspectImpl
extends PsiClassImpl
implements PsiAspect {
    private static final TokenSet INNER_CLASSES_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.CLASS, AspectJStubElementTypes.ASPECT});
    private static final String HAS_ASPECT = "hasAspect";
    private static final String ASPECT_OF = "aspectOf";

    public PsiAspectImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            PsiAspectImpl.$$$reportNull$$$0(0);
        }
        super(astNode);
    }

    public PsiAspectImpl(PsiAspectStub stub) {
        super((PsiClassStub)stub, AspectJStubElementTypes.ASPECT);
    }

    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list = Arrays.asList((PsiClass[])this.getStubOrPsiChildren(INNER_CLASSES_SET, PsiClass.ARRAY_FACTORY));
        if (list == null) {
            PsiAspectImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isRecord() {
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiAspectImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof AjElementVisitor) {
            ((AjElementVisitor)visitor).visitAspect(this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiModifierList modList;
        if (processor == null) {
            PsiAspectImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiAspectImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            PsiAspectImpl.$$$reportNull$$$0(5);
        }
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) && (modList = this.getModifierList()) != null && !modList.hasModifierProperty("abstract")) {
            PsiMethod candidate;
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if ((nameHint == null || HAS_ASPECT.equals(nameHint.getName(state))) && (candidate = this.getHasAspectMethod()) != null && !processor.execute((PsiElement)candidate, state)) {
                return false;
            }
            if ((nameHint == null || ASPECT_OF.equals(nameHint.getName(state))) && (candidate = this.getAspectOfMethod()) != null && !processor.execute((PsiElement)candidate, state)) {
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    private PsiMethod getHasAspectMethod() {
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiMethod method = InterTypeResolveUtil.createArtificialMethod("public static boolean hasAspect() {}", this);
            return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{this});
        });
    }

    @Nullable
    private synchronized PsiMethod getAspectOfMethod() {
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiIdentifier identifier = this.getNameIdentifier();
            if (identifier != null) {
                String text = "public static " + identifier.getText() + " aspectOf() {}";
                PsiMethod method = InterTypeResolveUtil.createArtificialMethod(text, this);
                return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{identifier});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{this});
        });
    }

    @Override
    @NotNull
    public List<PsiInterTypeDeclaration> getInterTypeDeclarations() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiInterTypeDeclaration.class);
        if (list == null) {
            PsiAspectImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean isPrivileged() {
        PsiModifierList modList = this.getModifierList();
        if (modList == null) {
            return false;
        }
        ASTNode node = modList.getNode();
        return node != null && node.findChildByType(AspectJTokenType.PRIVILEGED_KEYWORD) != null;
    }

    public Icon getIcon(int flags) {
        return AjPresentationUtil.getAspectIcon(this, flags);
    }

    public String toString() {
        return "PsiAspect:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/psi/impl/PsiAspectImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterTypeDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

