/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.parsing.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.parsing.AspectJTokenType;
import com.intellij.lang.aspectj.parsing.parser.AjParserUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class AjStatementParser {
    @Nullable
    public static PsiBuilder.Marker parseDeclare(PsiBuilder builder, PsiBuilder.Marker declaration) {
        assert (builder.getTokenType() == AspectJTokenType.DECLARE_KEYWORD) : builder.getTokenType();
        builder.advanceLexer();
        IElementType tokenType = builder.getTokenType();
        if (tokenType == AspectJTokenType.PARENTS_KEYWORD) {
            return AjStatementParser.parseParents(builder, declaration);
        }
        if (tokenType == AspectJTokenType.WARNING_KEYWORD || tokenType == AspectJTokenType.ERROR_KEYWORD) {
            return AjStatementParser.parseCompile(builder, declaration);
        }
        if (tokenType == AspectJTokenType.SOFT_KEYWORD) {
            return AjStatementParser.parseSoft(builder, declaration);
        }
        if (tokenType == AspectJTokenType.PRECEDENCE_KEYWORD) {
            return AjStatementParser.parsePrecedence(builder, declaration);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.AT)) {
            tokenType = builder.getTokenType();
            if (tokenType == AspectJTokenType.TYPE_KEYWORD) {
                return AjStatementParser.parseAnnotation(builder, declaration, AspectJElementType.INTER_TYPE_TYPE_ANNOTATION);
            }
            if (tokenType == AspectJTokenType.METHOD_KEYWORD) {
                return AjStatementParser.parseAnnotation(builder, declaration, AspectJElementType.INTER_TYPE_METHOD_ANNOTATION);
            }
            if (tokenType == AspectJTokenType.CONSTRUCTOR_KEYWORD) {
                return AjStatementParser.parseAnnotation(builder, declaration, AspectJElementType.INTER_TYPE_CTOR_ANNOTATION);
            }
            if (tokenType == AspectJTokenType.FIELD_KEYWORD) {
                return AjStatementParser.parseAnnotation(builder, declaration, AspectJElementType.INTER_TYPE_FIELD_ANNOTATION);
            }
        }
        AjParserUtil.unexpected(builder);
        declaration.drop();
        return null;
    }

    private static PsiBuilder.Marker parseParents(PsiBuilder builder, PsiBuilder.Marker marker) {
        return AjStatementParser.parseUnsupported(builder, marker);
    }

    @Nullable
    private static PsiBuilder.Marker parseCompile(PsiBuilder builder, PsiBuilder.Marker declaration) {
        builder.advanceLexer();
        if (!JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon")) {
            declaration.drop();
            return null;
        }
        AjParserUtil.parsePointcutExpression(builder, JavaTokenType.COLON);
        JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon");
        if (!JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.STRING_LITERAL, (String)"expected.string")) {
            declaration.drop();
            return null;
        }
        AjParserUtil.semicolon(builder);
        declaration.done(AspectJElementType.UNSUPPORTED);
        return declaration;
    }

    @Nullable
    private static PsiBuilder.Marker parseSoft(PsiBuilder builder, PsiBuilder.Marker declaration) {
        builder.advanceLexer();
        if (!JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon")) {
            declaration.drop();
            return null;
        }
        PsiBuilder.Marker ref = JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
        if (ref == null) {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]));
            declaration.drop();
            return null;
        }
        ref.precede().done(JavaElementType.TYPE);
        if (!JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon")) {
            declaration.drop();
            return null;
        }
        AjParserUtil.parsePointcutExpression(builder, JavaTokenType.SEMICOLON);
        AjParserUtil.semicolon(builder);
        declaration.done(AspectJElementType.UNSUPPORTED);
        return declaration;
    }

    private static PsiBuilder.Marker parsePrecedence(PsiBuilder builder, PsiBuilder.Marker marker) {
        return AjStatementParser.parseUnsupported(builder, marker);
    }

    @Nullable
    private static PsiBuilder.Marker parseAnnotation(PsiBuilder builder, PsiBuilder.Marker declaration, IElementType type) {
        builder.advanceLexer();
        if (!JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon")) {
            declaration.drop();
            return null;
        }
        AjParserUtil.parsePointcutExpression(builder, JavaTokenType.COLON);
        JavaParserUtil.expectOrError((PsiBuilder)builder, (IElementType)JavaTokenType.COLON, (String)"expected.colon");
        if (builder.getTokenType() != JavaTokenType.AT) {
            JavaParserUtil.error((PsiBuilder)builder, (String)AspectJBundle.message("parser.message.annotation.expected", new Object[0]));
            declaration.drop();
            return null;
        }
        JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        AjParserUtil.semicolon(builder);
        declaration.done(type);
        return declaration;
    }

    private static PsiBuilder.Marker parseUnsupported(PsiBuilder builder, PsiBuilder.Marker marker) {
        while (!builder.eof() && builder.getTokenType() != JavaTokenType.SEMICOLON) {
            builder.advanceLexer();
        }
        AjParserUtil.semicolon(builder);
        marker.done(AspectJElementType.UNSUPPORTED);
        return marker;
    }
}

