/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.ref;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;

public class TypeReferenceListAnnotator2
extends ElementAnnotator<PsiInterTypeReference> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiInterTypeReference reference) {
        PsiReferenceParameterList parameterList = reference.getReferenceElement().getParameterList();
        if (parameterList == null) {
            return false;
        }
        boolean annotated = false;
        for (PsiTypeElement typeElement : parameterList.getTypeParameterElements()) {
            if (!(typeElement.getType() instanceof PsiWildcardType)) continue;
            holder.newAnnotation(HighlightSeverity.ERROR, AspectJBundle.message("highlighting.wildcard.not.allowed", new Object[0])).range((PsiElement)typeElement).create();
            annotated = true;
        }
        return annotated;
    }
}

