/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.ref;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiTreeUtil;

public class NonStaticAspectMemberAccessAnnotator
extends ElementAnnotator<PsiJavaCodeReferenceElement> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiJavaCodeReferenceElement reference) {
        if (reference.isQualified()) {
            return false;
        }
        PsiMember block = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMember.class);
        if (!(block instanceof PsiInterTypeDeclaration)) {
            return false;
        }
        PsiElement target = reference.resolve();
        if (!(target instanceof PsiMember) || target instanceof PsiInterTypeDeclaration) {
            return false;
        }
        PsiElement targetContainer = target.getParent();
        if (!(targetContainer instanceof PsiAspect)) {
            return false;
        }
        PsiModifierList modList = ((PsiMember)target).getModifierList();
        if (modList == null || modList.hasModifierProperty("static")) {
            return false;
        }
        PsiElement nameElement = reference.getReferenceNameElement();
        PsiElement refElement = nameElement != null ? nameElement : reference;
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)target, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        holder.newAnnotation(HighlightSeverity.ERROR, AspectJBundle.message("highlighting.non.static.access", symbolName)).range(refElement).create();
        return true;
    }
}

