/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.ref;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.quickFix.MakeAspectAbstractFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;

public class AspectInheritanceAnnotator
extends ElementAnnotator<PsiJavaCodeReferenceElement> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiJavaCodeReferenceElement reference) {
        PsiElement parent = reference.getParent();
        if (!(parent instanceof PsiReferenceList) || ((PsiReferenceList)parent).getRole() != PsiReferenceList.Role.EXTENDS_LIST) {
            return false;
        }
        PsiElement target = reference.resolve();
        if (!(target instanceof PsiAspect)) {
            return false;
        }
        PsiAspect aspect = (PsiAspect)target;
        String aspectName = HighlightMessageUtil.getSymbolName((PsiElement)aspect, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiElement refListParent = parent.getParent();
        if (refListParent instanceof PsiClass && !(refListParent instanceof PsiAspect)) {
            String className = HighlightMessageUtil.getSymbolName((PsiElement)refListParent, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            holder.newAnnotation(HighlightSeverity.ERROR, AspectJBundle.message("highlighting.inherits.aspect", className, aspectName)).create();
            return true;
        }
        PsiModifierList modList = aspect.getModifierList();
        if (modList == null || modList.hasModifierProperty("abstract") || modList.hasModifierProperty("final")) {
            return false;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, AspectJBundle.message("highlighting.inherits.concrete", aspectName)).withFix((IntentionAction)new MakeAspectAbstractFix(aspect)).create();
        return true;
    }
}

