/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.member;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;

public class SuperConstructorCallAnnotator
extends ElementAnnotator<PsiMethod> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiMethod method) {
        PsiReferenceExpression methodExpression;
        String refName;
        PsiExpression expression;
        if (!method.isConstructor()) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiJavaToken brace = body.getLBrace();
        if (brace == null) {
            return false;
        }
        PsiElement first = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)brace);
        if (first == null) {
            return false;
        }
        if (first instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && ("this".equals(refName = (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).getReferenceName()) || "super".equals(refName))) {
            return false;
        }
        TextRange range = HighlightNamesUtil.getMethodDeclarationTextRange((PsiMethod)method);
        holder.newAnnotation(HighlightSeverity.WARNING, AspectJBundle.message("highlighting.explicit.constructor.call", new Object[0])).range(range).create();
        return false;
    }
}

