/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.member;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.AnnotationUtil;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;

public class InterTypeModifiersAnnotator<T extends PsiMember>
extends ElementAnnotator<T> {
    @Override
    public boolean annotate(AnnotationHolder holder, T member) {
        PsiModifierList modList = member.getModifierList();
        if (modList == null || !modList.hasModifierProperty("protected")) {
            return false;
        }
        TextRange range = AnnotationUtil.memberRange(member);
        holder.newAnnotation(HighlightSeverity.ERROR, AspectJBundle.message("highlighting.protected.declaration", new Object[0])).range(range).create();
        return true;
    }
}

