/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.aspect;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.quickFix.MakeAspectAbstractFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameterList;

public class GenericAspectAbstractAnnotator
extends ElementAnnotator<PsiAspect> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiAspect aspect) {
        PsiTypeParameterList typeParameterList = aspect.getTypeParameterList();
        if (typeParameterList == null || typeParameterList.getTypeParameters().length == 0 || aspect.hasModifierProperty("abstract")) {
            return false;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, AspectJBundle.message("highlighting.generic.abstract", new Object[0])).range((PsiElement)typeParameterList).withFix((IntentionAction)new MakeAspectAbstractFix(aspect)).create();
        return true;
    }
}

