/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static void createErrorAnnotation(AnnotationHolder holder, TextRange range, @InspectionMessage String message, String tooltip) {
        AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(range);
        if (tooltip != null) {
            builder = builder.tooltip(AspectJBundle.message("highlighting.tooltip.html", tooltip));
        }
        builder.create();
    }

    public static String link(PsiElement element, String text) {
        PsiFile psiFile = element.getContainingFile();
        assert (psiFile != null) : LogUtil.objectAndClass((Object)element);
        VirtualFile vFile = psiFile.getVirtualFile();
        assert (vFile != null) : LogUtil.objectAndClass((Object)element) + "; " + LogUtil.objectAndClass((Object)psiFile);
        String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
        return AspectJBundle.message("highlighting.tooltip.link", path, element.getTextOffset(), text);
    }

    public static boolean nonIntersecting(PsiMember member1, PsiMember member2) {
        PsiModifierList mods1 = member1.getModifierList();
        PsiModifierList mods2 = member2.getModifierList();
        return !(mods1 == null || !mods1.hasModifierProperty("private") && !mods1.hasModifierProperty("packageLocal") || mods2 == null || !mods2.hasModifierProperty("private") && !mods2.hasModifierProperty("packageLocal") || member1.getContainingFile().equals(member2.getContainingFile()));
    }

    public static TextRange memberRange(PsiMember member) {
        if (member instanceof PsiField) {
            return HighlightNamesUtil.getFieldDeclarationTextRange((PsiField)((PsiField)member));
        }
        if (member instanceof PsiMethod) {
            return HighlightNamesUtil.getMethodDeclarationTextRange((PsiMethod)((PsiMethod)member));
        }
        return member.getTextRange();
    }
}

