/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.search.AjScopeEnlarger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            AjImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return AjImplicitUsageProvider.hasUsageOfType(element, null);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            AjImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return AjImplicitUsageProvider.hasUsageOfType(element, UsageType.READ);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            AjImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return AjImplicitUsageProvider.hasUsageOfType(element, UsageType.WRITE);
    }

    private static boolean hasUsageOfType(PsiElement element, @Nullable UsageType usage) {
        if (!(element instanceof PsiMember)) {
            return false;
        }
        PsiMember member = (PsiMember)element;
        Ref found = Ref.create((Object)false);
        AjScopeEnlarger.search(member, (Processor<? super PsiReference>)((Processor)reference -> {
            if (!reference.isReferenceTo((PsiElement)member) || !AjImplicitUsageProvider.isAccessible(member, reference)) {
                return true;
            }
            if (usage == null) {
                found.set((Object)true);
                return false;
            }
            PsiElement refElement = reference.getElement();
            if (!(refElement instanceof PsiExpression)) {
                return true;
            }
            if (usage == UsageType.READ) {
                if (PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)refElement))) {
                    found.set((Object)true);
                    return false;
                }
            } else if (usage == UsageType.WRITE && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) {
                found.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)found.get();
    }

    private static boolean isAccessible(PsiMember member, PsiReference reference) {
        PsiElement memberContainer;
        if (member instanceof PsiTypeParameter) {
            return true;
        }
        PsiMember block = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMember.class);
        if (!(block instanceof PsiInterTypeDeclaration)) {
            return false;
        }
        PsiInterTypeDeclaration refDeclaration = (PsiInterTypeDeclaration)block;
        PsiAspect refAspect = refDeclaration.getAspect();
        if (refAspect.equals(memberContainer = member.getParent())) {
            return true;
        }
        PsiClass memberClass = member.getContainingClass();
        return refAspect.isPrivileged() && memberClass != null && memberClass.equals(refDeclaration.getInterTypeReference().getReferencedClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/lang/aspectj/highlight/AjImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

