/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build.ui;

import com.intellij.DynamicBundle;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.AjIdeaCompiler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjBuildProcessParametersProvider;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

public class AjCompilerOptionsPanel {
    private final Project myProject;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myAjcPath;
    private RawCommandLineEditor myCmdLineParams;
    private JButton myTestButton;
    private JBCheckBox myGenerateDebugInfo;
    private JBCheckBox myDelegateToJavac;
    private JCheckBox myAptOptionsEnabled;
    private String myHeapSize;

    public AjCompilerOptionsPanel(@NotNull Project project) {
        if (project == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(0);
        }
        this.myHeapSize = "";
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        String description = AspectJBundle.message("compiler.ajc.select.path", objectArray);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                AjCompilerOptionsPanel.checkCompilerJar(files[0].getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel$1", "validateSelectedFiles"));
            }
        };
        this.myAjcPath.addBrowseFolderListener(null, description, null, descriptor);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjCompilerOptionsPanel.this.testCompiler();
            }
        });
    }

    private void testCompiler() {
        String path = this.getAjcPath();
        String heapSize = this.getHeapSize();
        try {
            AjCompilerOptionsPanel.checkCompilerJar(path);
            if (!StringUtil.isEmpty((String)heapSize)) {
                int hs = -1;
                try {
                    hs = Integer.parseInt(heapSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (hs <= 0) {
                    throw new IllegalArgumentException(AspectJBundle.message("compiler.ajc.bad.heap", new Object[0]));
                }
            }
            String version = AjIdeaCompiler.testCompiler(this.myProject, path, heapSize);
            Messages.showInfoMessage((String)version, (String)AspectJBundle.message("compiler.ajc.test.ok", new Object[0]));
        }
        catch (ProcessCanceledException version) {
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)AspectJBundle.message("compiler.ajc.error", new Object[0]));
        }
    }

    private static void checkCompilerJar(String path) throws Exception {
        if (!AjBuildProcessParametersProvider.checkCompilerJar(path)) {
            throw new IOException(AjJpsBundle.message((String)"aj.compiler.path.incorrect", (Object[])new Object[]{FileUtil.toSystemDependentName((String)path)}));
        }
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public String getAjcPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myAjcPath.getText().trim());
        if (string == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setAjcPath(@NotNull String ajcPath) {
        if (ajcPath == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(3);
        }
        this.myAjcPath.setText(FileUtil.toSystemDependentName((String)ajcPath));
    }

    @NotNull
    public String getHeapSize() {
        String string = this.myHeapSize;
        if (string == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setHeapSize(@NotNull String heapSize) {
        if (heapSize == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(5);
        }
        this.myHeapSize = heapSize;
    }

    @NotNull
    public String getCmdLineParams() {
        String string = this.myCmdLineParams.getText().trim();
        if (string == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setCmdLineParams(@NotNull String params) {
        if (params == null) {
            AjCompilerOptionsPanel.$$$reportNull$$$0(7);
        }
        this.myCmdLineParams.setText(params);
    }

    public boolean isGenerateDebugInfo() {
        return this.myGenerateDebugInfo.isSelected();
    }

    public void setGenerateDebugInfo(boolean generateDebugInfo) {
        this.myGenerateDebugInfo.setSelected(generateDebugInfo);
    }

    public boolean isDelegateToJavac() {
        return this.myDelegateToJavac.isSelected();
    }

    public void setDelegateToJavac(boolean delegateToJavac) {
        this.myDelegateToJavac.setSelected(delegateToJavac);
    }

    public boolean areAptOptionsEnabled() {
        return this.myAptOptionsEnabled.isSelected();
    }

    public void setAptOptionsEnabled(boolean aptOptionsEnabled) {
        this.myAptOptionsEnabled.setSelected(aptOptionsEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ajcPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapSize";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAjcPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCmdLineParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAjcPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHeapSize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCmdLineParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        RawCommandLineEditor rawCommandLineEditor;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("border.title.ajc.options"), (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel.getFont()), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("label.path.to.aspectjtools.jar"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        this.myAjcPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myTestButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("aj.button.test"));
        jPanel.add((Component)jButton, new GridConstraints(0, 4, 1, 1, 8, 0, 1, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("label.command.line.parameters"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myCmdLineParams = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/AspectJBundle").getString("command.line.parameters"));
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myGenerateDebugInfo = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("checkbox.generate.debug.info"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myDelegateToJavac = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("checkbox.delegate.to.javac"));
        jBCheckBox.setToolTipText(ResourceBundle.getBundle("messages/AspectJBundle").getString("use.javac.to.compile.modules.without.aspectj.facet.or.with.post.compile.weaving.enabled"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myAptOptionsEnabled = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AspectJBundle", AjCompilerOptionsPanel.class).getString("checkbox.enable.annotation.processing.options"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/AspectJBundle").getString("produce.annotation.processing.options.for.experimental.ajc.builds.which.are.able.to.handle.them"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

