/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.aspectj.AjFileType;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.AjCompilerConfigurable;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjIdeaCompilerSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.CompilerOptions;

public class AjIdeaCompiler
implements BackendCompiler {
    private static final Set<FileType> COMPILABLE_TYPES = ContainerUtil.newHashSet((Object[])new FileType[]{JavaFileType.INSTANCE, AjFileType.INSTANCE});
    private final Project myProject;

    public AjIdeaCompiler(@NotNull Project project) {
        if (project == null) {
            AjIdeaCompiler.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<FileType> set = COMPILABLE_TYPES;
        if (set == null) {
            AjIdeaCompiler.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public String getId() {
        return "ajc";
    }

    @NotNull
    public String getPresentableName() {
        String string = AspectJBundle.message("compiler.ajc.name", new Object[0]);
        if (string == null) {
            AjIdeaCompiler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public CompilerOptions getOptions() {
        AjCompilerSettings ajCompilerSettings = AjIdeaCompilerSettings.getSettings(this.myProject);
        if (ajCompilerSettings == null) {
            AjIdeaCompiler.$$$reportNull$$$0(3);
        }
        return ajCompilerSettings;
    }

    @NotNull
    public Configurable createConfigurable() {
        return new AjCompilerConfigurable(AjIdeaCompilerSettings.getSettings(this.myProject), this.myProject);
    }

    @Nls
    public static String testCompiler(Project project, String ajToolsJarPath, String heapSize) throws Exception {
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GeneralCommandLine command = AjIdeaCompiler.getCommandLine(project, ajToolsJarPath, heapSize);
            Future<ProcessOutput> task = ProcessIOExecutorService.INSTANCE.submit(() -> new CapturingProcessHandler(command).runProcess());
            ProcessOutput output = (ProcessOutput)ProgressIndicatorUtils.awaitWithCheckCanceled(task);
            String out = output.getStdout().trim();
            if (output.getExitCode() != 0) {
                throw new IOException(out);
            }
            return out;
        }, AspectJBundle.message("compiler.ajc.checking", new Object[0]), true, project);
    }

    private static GeneralCommandLine getCommandLine(Project project, String ajToolsJarPath, String heapSize) {
        Sdk jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (jdk == null || !(jdk.getSdkType() instanceof JavaSdkType)) {
            throw new IllegalArgumentException(AspectJBundle.message("compiler.ajc.no.jdk", new Object[0]));
        }
        JavaSdkType sdkType = (JavaSdkType)jdk.getSdkType();
        String toolsJarPath = sdkType.getToolsPath(jdk);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(sdkType.getVMExecutablePath(jdk));
        commandLine.addParameter("-ea");
        if (!StringUtil.isEmpty((String)heapSize)) {
            commandLine.addParameter(StringUtil.join((String[])new String[]{"-Xmx", heapSize, "m"}));
        }
        commandLine.addParameter("-cp");
        commandLine.addParameter((String)(toolsJarPath != null ? toolsJarPath + File.pathSeparator + ajToolsJarPath : ajToolsJarPath));
        commandLine.addParameter("org.aspectj.tools.ajc.Main");
        commandLine.addParameter("-version");
        commandLine.setWorkDirectory(project.getBasePath());
        commandLine.setRedirectErrorStream(true);
        return commandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/build/AjIdeaCompiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/build/AjIdeaCompiler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

