/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.lang.aspectj.build.AjIdeaCompiler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjBuildProcessParametersProvider;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.ui.AjCompilerOptionsPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AjCompilerConfigurable
implements Configurable {
    private final AjCompilerSettings mySettings;
    private final Project myProject;
    private final CompilerConfigurationImpl myParentConfiguration;
    private AjCompilerOptionsPanel myOptionsPanel;

    public AjCompilerConfigurable(@NotNull AjCompilerSettings settings, @NotNull Project project) {
        if (settings == null) {
            AjCompilerConfigurable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AjCompilerConfigurable.$$$reportNull$$$0(1);
        }
        this.myOptionsPanel = null;
        this.mySettings = settings;
        this.myProject = project;
        this.myParentConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
    }

    @Nls
    public String getDisplayName() {
        return null;
    }

    public JComponent createComponent() {
        this.myOptionsPanel = new AjCompilerOptionsPanel(this.myProject);
        return this.myOptionsPanel.getComponent();
    }

    public boolean isModified() {
        return !Objects.equals(this.myOptionsPanel.getAjcPath(), this.mySettings.ajcPath) || !Objects.equals(this.myOptionsPanel.getCmdLineParams(), this.mySettings.cmdLineParams) || !Comparing.equal((Object)this.myOptionsPanel.isGenerateDebugInfo(), (Object)this.mySettings.debugInfo) || !Comparing.equal((Object)this.myOptionsPanel.isDelegateToJavac(), (Object)this.mySettings.delegateToJavac) || !Comparing.equal((Object)this.myOptionsPanel.areAptOptionsEnabled(), (Object)this.mySettings.aptOptionsEnabled);
    }

    public void apply() throws ConfigurationException {
        String path = this.myOptionsPanel.getAjcPath();
        if (this.myParentConfiguration.getDefaultCompiler() instanceof AjIdeaCompiler && !AjBuildProcessParametersProvider.checkCompilerJar(path)) {
            throw new ConfigurationException(AjJpsBundle.message((String)"aj.compiler.path.incorrect", (Object[])new Object[]{FileUtil.toSystemDependentName((String)path)}));
        }
        this.mySettings.ajcPath = path;
        this.mySettings.cmdLineParams = this.myOptionsPanel.getCmdLineParams();
        this.mySettings.debugInfo = this.myOptionsPanel.isGenerateDebugInfo();
        this.mySettings.delegateToJavac = this.myOptionsPanel.isDelegateToJavac();
        this.mySettings.aptOptionsEnabled = this.myOptionsPanel.areAptOptionsEnabled();
    }

    public void reset() {
        this.myOptionsPanel.setAjcPath(this.mySettings.ajcPath);
        this.myOptionsPanel.setHeapSize(this.mySettings.heapSize);
        this.myOptionsPanel.setCmdLineParams(this.mySettings.cmdLineParams);
        this.myOptionsPanel.setGenerateDebugInfo(this.mySettings.debugInfo);
        this.myOptionsPanel.setDelegateToJavac(this.mySettings.delegateToJavac);
        this.myOptionsPanel.setAptOptionsEnabled(this.mySettings.aptOptionsEnabled);
    }

    public void disposeUIResources() {
        this.myOptionsPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/aspectj/build/AjCompilerConfigurable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

