/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.util.AjFileTemplateUtil;
import com.intellij.lang.aspectj.util.LibraryUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import icons.AspectjIcons;
import org.jetbrains.annotations.NotNull;

public class CreateAspectAction
extends JavaCreateTemplateInPackageAction<PsiClass> {
    public CreateAspectAction() {
        super("", AspectJBundle.message("action.create.aspect.description", new Object[0]), AspectjIcons.Aspect, true);
    }

    protected PsiElement getNavigationElement(@NotNull PsiClass createdElement) {
        if (createdElement == null) {
            CreateAspectAction.$$$reportNull$$$0(0);
        }
        return createdElement;
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        if (project == null) {
            CreateAspectAction.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            CreateAspectAction.$$$reportNull$$$0(2);
        }
        builder.setTitle(AspectJBundle.message("action.create.aspect.name", new Object[0])).addKind(AspectJBundle.message("action.create.aspect.kind.class", new Object[0]), AspectjIcons.Aspect, "Aspect.aj").addKind(AspectJBundle.message("action.create.aspect.kind.annotation", new Object[0]), PlatformIcons.CLASS_ICON, "@Aspect.java");
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibraryUtil.hasAjRunTime((Module)LangDataKeys.MODULE.getData(dataContext));
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected PsiClass doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        if (templateName.endsWith(".aj")) {
            return AjFileTemplateUtil.createAspectFromTemplate(dir, className, templateName);
        }
        return JavaDirectoryService.getInstance().createClass(dir, className, templateName, true);
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        String packageName;
        PsiPackage aPackage;
        if (newName == null) {
            CreateAspectAction.$$$reportNull$$$0(3);
        }
        if ((aPackage = JavaDirectoryService.getInstance().getPackage(directory)) != null && !StringUtil.isEmptyOrSpaces((String)(packageName = aPackage.getName()))) {
            newName = aPackage.getQualifiedName() + "." + (String)newName;
        }
        return AspectJBundle.message("action.create.aspect.title", newName);
    }

    @NotNull
    protected String getErrorTitle() {
        String string = AspectJBundle.message("action.create.aspect.error", new Object[0]);
        if (string == null) {
            CreateAspectAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/actions/CreateAspectAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/actions/CreateAspectAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDialog";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

