/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeAnnotation;
import com.intellij.lang.aspectj.util.FileIndexUtil;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import icons.AspectjIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjIconProvider
extends IconProvider {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            AjIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiAspectJFile) {
            VirtualFile vFile = ((PsiAspectJFile)element).getVirtualFile();
            if (vFile == null) {
                return AllIcons.FileTypes.Aspectj;
            }
            if (!FileIndexUtil.isAspectJSourceFile(vFile, element.getProject())) {
                return AspectjIcons.AspectjOutsideSource;
            }
            Icon icon = AjIconProvider.getIconByAspects(vFile, (PsiAspectJFile)element, flags);
            if (icon != null && CompilerManager.getInstance((Project)element.getProject()).isExcludedFromCompilation(vFile)) {
                icon = new LayeredIcon(new Icon[]{icon, PlatformIcons.EXCLUDED_FROM_COMPILE_ICON});
            }
            return icon != null ? icon : AllIcons.FileTypes.Aspectj;
        }
        if (element instanceof PsiInterTypeAnnotation) {
            return PlatformIcons.ANNOTATION_TYPE_ICON;
        }
        return null;
    }

    @Nullable
    private static Icon getIconByAspects(VirtualFile vFile, PsiAspectJFile psiFile, @Iconable.IconFlags int flags) {
        String fileName = vFile.getNameWithoutExtension();
        List<PsiAspect> aspects = psiFile.getAspects();
        for (PsiAspect aspect : aspects) {
            if (!fileName.equals(aspect.getName())) continue;
            return aspect.getIcon(flags);
        }
        if (aspects.size() > 0) {
            return aspects.get(0).getIcon(flags);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/AjIconProvider", "getIcon"));
    }
}

