/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LanguageExtension;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.ExtensionPoints;
import org.jetbrains.idea.devkit.inspections.DummyUsageTarget;
import org.jetbrains.idea.devkit.inspections.EPElementUsage;
import org.jetbrains.idea.devkit.inspections.EPUsageTarget;
import org.jetbrains.idea.devkit.inspections.ExtensionPointUsageAnalyzerKt;
import org.jetbrains.idea.devkit.inspections.Leak;
import org.jetbrains.idea.devkit.inspections.LeakSearchContext;
import org.jetbrains.idea.devkit.inspections.QualifiedCall;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a2\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002\u001a&\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u00a8\u0006#"}, d2={"analyze", "", "elementAtCaret", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ignoreSafeClasses", "", "analyzeEPFieldUsages", "target", "Lorg/jetbrains/uast/UField;", "epName", "", "analyzeEPTagUsages", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "batchAnalyzeEPTagUsages", "findQualifiedCall", "Lorg/jetbrains/idea/devkit/inspections/QualifiedCall;", "element", "Lorg/jetbrains/uast/UElement;", "isEPField", "field", "Lcom/intellij/psi/PsiField;", "isInPluginModule", "showEPElementUsages", "project", "Lcom/intellij/openapi/project/Project;", "usageTarget", "Lcom/intellij/usages/UsageTarget;", "usages", "", "Lorg/jetbrains/idea/devkit/inspections/EPElementUsage;", "intellij.devkit"})
public final class ExtensionPointUsageAnalyzerKt {
    private static final QualifiedCall findQualifiedCall(UElement element) {
        UExpression selector;
        UQualifiedReferenceExpression qualifiedExpression;
        UQualifiedReferenceExpression uQualifiedReferenceExpression;
        UCallExpression callExpression;
        UCallExpression uCallExpression;
        UElement uElement = element;
        if (uElement != null) {
            UElement $this$getParentOfType$iv = uElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UCallExpression.class, (boolean)strict$iv);
        } else {
            uCallExpression = callExpression = null;
        }
        if (callExpression != null && Intrinsics.areEqual((Object)element, (Object)callExpression.getReceiver())) {
            return new QualifiedCall(callExpression, (UExpression)callExpression);
        }
        UElement uElement2 = element;
        if (uElement2 != null) {
            UElement $this$getParentOfType$iv = uElement2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uQualifiedReferenceExpression = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv);
        } else {
            uQualifiedReferenceExpression = qualifiedExpression = null;
        }
        if (qualifiedExpression != null && Intrinsics.areEqual((Object)qualifiedExpression.getReceiver(), (Object)element) && (selector = qualifiedExpression.getSelector()) instanceof UCallExpression) {
            return new QualifiedCall((UCallExpression)selector, (UExpression)qualifiedExpression);
        }
        return null;
    }

    private static final void analyze(PsiElement elementAtCaret, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        XmlTag xmlTag;
        PsiElement $this$getUastParentOfType$iv = elementAtCaret;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UField target = (UField)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType$iv, UField.class, (boolean)strict$iv);
        if (target != null) {
            PsiElement psiElement = target.getJavaPsi();
            if (!(psiElement instanceof PsiField)) {
                psiElement = null;
            }
            PsiField psiField = (PsiField)psiElement;
            PsiClass psiClass = psiField != null ? psiField.getContainingClass() : null;
            String epName = null;
            if (psiClass != null) {
                ExtensionPointCandidate extensionPointCandidate = (ExtensionPointCandidate)ContainerUtil.getOnlyItem((Collection)new ExtensionPointLocator(psiClass).findDirectCandidates());
                epName = extensionPointCandidate != null ? extensionPointCandidate.epName : null;
            }
            ExtensionPointUsageAnalyzerKt.analyzeEPFieldUsages(target, file, editor, epName, ignoreSafeClasses);
        }
        if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, XmlTag.class)) != null) {
            if (Intrinsics.areEqual((Object)xmlTag.getName(), (Object)"extensionPoint")) {
                ExtensionPointUsageAnalyzerKt.analyzeEPTagUsages(xmlTag, file, editor, ignoreSafeClasses);
            } else if (Intrinsics.areEqual((Object)xmlTag.getName(), (Object)"extensionPoints")) {
                ExtensionPointUsageAnalyzerKt.batchAnalyzeEPTagUsages(xmlTag, file, editor, ignoreSafeClasses);
            }
        }
    }

    private static final boolean isEPField(PsiField field) {
        PsiClassReferenceType psiClassReferenceType;
        PsiField psiField = field;
        Object object = psiField != null ? psiField.getType() : null;
        if (!(object instanceof PsiClassReferenceType)) {
            object = null;
        }
        if ((psiClassReferenceType = (PsiClassReferenceType)object) == null || (psiClassReferenceType = psiClassReferenceType.rawType()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClassReferenceType, (String)"(field?.type as? PsiClas\u2026rawType() ?: return false");
        PsiClassReferenceType fieldType = psiClassReferenceType;
        return Intrinsics.areEqual((Object)fieldType.getCanonicalText(), (Object)ExtensionPointName.class.getName()) || Intrinsics.areEqual((Object)fieldType.getCanonicalText(), (Object)ProjectExtensionPointName.class.getName()) || Intrinsics.areEqual((Object)fieldType.getCanonicalText(), (Object)LanguageExtension.class.getName());
    }

    private static final void analyzeEPFieldUsages(UField target, PsiFile file, Editor editor, String epName, boolean ignoreSafeClasses) {
        PsiElement psiElement = target.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        PsiElement psiElement2 = target.getJavaPsi();
        if (!(psiElement2 instanceof PsiField)) {
            psiElement2 = null;
        }
        if (!ExtensionPointUsageAnalyzerKt.isEPField((PsiField)psiElement2)) {
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.not.extension.point.name", new Object[0]));
            return;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        LeakSearchContext context = new LeakSearchContext(project, epName, ignoreSafeClasses);
        Task.Backgroundable task2 = new Task.Backgroundable(context, sourcePsi, editor, file, target, file.getProject(), DevKitBundle.message("extension.point.analyzer.analyze.title", new Object[0])){
            final /* synthetic */ LeakSearchContext $context;
            final /* synthetic */ PsiElement $sourcePsi;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ UField $target;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$context.processEPFieldUsages(this.$sourcePsi);
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ analyzeEPFieldUsages.task.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        if (this.this$0.$context.getUnsafeUsages().isEmpty()) {
                            if (this.this$0.$context.getSafeUsages().isEmpty()) {
                                HintManager.getInstance().showErrorHint(this.this$0.$editor, DevKitBundle.message("extension.point.analyzer.analyze.no.usages", new Object[0]));
                            } else {
                                HintManager.getInstance().showInformationHint(this.this$0.$editor, DevKitBundle.message("extension.point.analyzer.analyze.usage.all.safe", new Object[0]));
                            }
                        } else {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = this.this$0.$context.getUnsafeUsages();
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                Pair pair = (Pair)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                PsiElement psiElement = ((Leak)it.getSecond()).getTargetElement();
                                if (psiElement == null) {
                                    PsiElement psiElement2 = ((PsiReference)it.getFirst()).getElement();
                                    psiElement = psiElement2;
                                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.first.element");
                                }
                                EPElementUsage ePElementUsage = new EPElementUsage(psiElement, ((Leak)it.getSecond()).getReason());
                                collection.add(ePElementUsage);
                            }
                            List usages = (List)destination$iv$iv;
                            Project project = this.this$0.$file.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                            PsiElement psiElement = this.this$0.$target.getSourcePsi();
                            if (psiElement == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiField");
                            }
                            ExtensionPointUsageAnalyzerKt.access$showEPElementUsages(project, new EPUsageTarget((PsiField)psiElement), usages);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$context = $captured_local_variable$0;
                this.$sourcePsi = $captured_local_variable$1;
                this.$editor = $captured_local_variable$2;
                this.$file = $captured_local_variable$3;
                this.$target = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void showEPElementUsages(Project project, UsageTarget usageTarget, List<EPElementUsage> usages) {
        void $this$apply;
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        EPElementUsage[] ePElementUsageArray = thisCollection$iv.toArray(new EPElementUsage[0]);
        if (ePElementUsageArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        boolean bl = false;
        boolean bl2 = false;
        UsageViewPresentation usageViewPresentation2 = usageViewPresentation;
        Usage[] usageArray = (Usage[])ePElementUsageArray;
        UsageTarget[] usageTargetArray = new UsageTarget[]{usageTarget};
        UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
        boolean bl3 = false;
        ItemPresentation itemPresentation = usageTarget.getPresentation();
        Intrinsics.checkNotNull((Object)itemPresentation);
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"usageTarget.presentation!!");
        $this$apply.setTabText(itemPresentation.getPresentableText());
        $this$apply.setOpenInNewTab(true);
        Unit unit = Unit.INSTANCE;
        usageViewManager.showUsages(usageTargetArray, usageArray, usageViewPresentation);
    }

    private static final void analyzeEPTagUsages(XmlTag xmlTag, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        PsiField psiField;
        boolean bl7;
        ExtensionPoint domElement;
        block8: {
            DomElement domElement2 = DomManager.getDomManager((Project)file.getProject()).getDomElement(xmlTag);
            if (!(domElement2 instanceof ExtensionPoint)) {
                domElement2 = null;
            }
            if ((domElement = (ExtensionPoint)domElement2) == null) {
                HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.not.extension.point", new Object[0]));
                return;
            }
            PsiClass psiClass = domElement.getEffectiveClass();
            if (psiClass == null) {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.cannot.resolve.ep.class", new Object[0]));
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"domElement.effectiveClas\u2026p.class\"))\n    return\n  }");
            PsiClass effectiveClass = psiClass;
            if (Intrinsics.areEqual((Object)effectiveClass.getQualifiedName(), (Object)"com.intellij.lang.LanguageExtensionPoint")) {
                PsiClass psiClass2 = (PsiClass)ContainerUtil.getOnlyItem((Collection)domElement.getWithElements());
                if (psiClass2 == null || (psiClass2 = psiClass2.getImplements()) == null || (psiClass2 = (PsiClass)psiClass2.getValue()) == null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.no.implementation.language.extension.point", new Object[0]));
                    return;
                }
                effectiveClass = psiClass2;
            }
            PsiField[] psiFieldArray = effectiveClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"effectiveClass.fields");
            PsiField[] psiFieldArray2 = psiFieldArray;
            bl7 = false;
            PsiField[] psiFieldArray3 = psiFieldArray2;
            boolean bl8 = false;
            PsiField[] psiFieldArray4 = psiFieldArray3;
            int n = psiFieldArray4.length;
            for (int i = 0; i < n; ++i) {
                PsiField psiField2;
                PsiField it = psiField2 = psiFieldArray4[i];
                boolean bl9 = false;
                if (!ExtensionPointUsageAnalyzerKt.isEPField(it)) continue;
                psiField = psiField2;
                break block8;
            }
            psiField = null;
        }
        if (psiField == null) {
            boolean bl10 = false;
            bl7 = false;
            boolean bl11 = false;
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.no.extension.point.name.field", new Object[0]));
            return;
        }
        PsiField epField = psiField;
        PsiElement $this$toUElementOfType$iv = (PsiElement)epField;
        boolean $i$f$toUElementOfType = false;
        UField uField = (UField)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UField.class);
        if (uField == null) {
            return;
        }
        UField epUField = uField;
        ExtensionPointUsageAnalyzerKt.analyzeEPFieldUsages(epUField, file, editor, domElement.getEffectiveQualifiedName(), ignoreSafeClasses);
    }

    private static final void batchAnalyzeEPTagUsages(XmlTag xmlTag, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        ExtensionPoints domElement;
        DomElement domElement2 = DomManager.getDomManager((Project)file.getProject()).getDomElement(xmlTag);
        if (!(domElement2 instanceof ExtensionPoints)) {
            domElement2 = null;
        }
        if ((domElement = (ExtensionPoints)domElement2) == null) {
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.batch.not.extension.points", new Object[0]));
            return;
        }
        boolean bl = false;
        List safeEPs = new ArrayList();
        boolean bl2 = false;
        List allUnsafeUsages = new ArrayList();
        Task.Backgroundable task2 = new Task.Backgroundable(domElement, allUnsafeUsages, file, ignoreSafeClasses, safeEPs, file.getProject(), DevKitBundle.message("extension.point.analyzer.analyze.xml.batch.title", new Object[0])){
            final /* synthetic */ ExtensionPoints $domElement;
            final /* synthetic */ List $allUnsafeUsages;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ boolean $ignoreSafeClasses;
            final /* synthetic */ List $safeEPs;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                    final /* synthetic */ batchAnalyzeEPTagUsages.task.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)this.this$0.$domElement.getExtensionPoints();
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { domElement.extensionPoints }");
                List extensionPoints = (List)object;
                for (ExtensionPoint extensionPoint : extensionPoints) {
                    boolean $i$f$runReadAction2 = false;
                    ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this, extensionPoint, indicator){
                        final /* synthetic */ batchAnalyzeEPTagUsages.task.1 this$0;
                        final /* synthetic */ ExtensionPoint $extensionPoint$inlined;
                        final /* synthetic */ ProgressIndicator $indicator$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$extensionPoint$inlined = extensionPoint;
                            this.$indicator$inlined = progressIndicator;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final T compute() {
                            boolean bl = false;
                            ExtensionPoint extensionPoint = this.$extensionPoint$inlined;
                            Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"extensionPoint");
                            GenericAttributeValue<Boolean> genericAttributeValue = extensionPoint.getDynamic();
                            Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"extensionPoint.dynamic");
                            if (genericAttributeValue.getValue() == null) {
                                ExtensionPoint extensionPoint2 = this.$extensionPoint$inlined;
                                Intrinsics.checkNotNullExpressionValue((Object)extensionPoint2, (String)"extensionPoint");
                                this.$indicator$inlined.setText(extensionPoint2.getEffectiveQualifiedName());
                                ExtensionPoint extensionPoint3 = this.$extensionPoint$inlined;
                                Intrinsics.checkNotNullExpressionValue((Object)extensionPoint3, (String)"extensionPoint");
                                GenericAttributeValue<String> genericAttributeValue2 = extensionPoint3.getName();
                                Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"extensionPoint.name");
                                XmlAttributeValue xmlAttributeValue = genericAttributeValue2.getXmlAttributeValue();
                                if (xmlAttributeValue == null) {
                                } else {
                                    Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeValue, (String)"extensionPoint.name.xmlA\u2026e ?: return@runReadAction");
                                    XmlAttributeValue epName = xmlAttributeValue;
                                    if (!ReferencesSearch.search((PsiElement)((PsiElement)epName)).anyMatch((Predicate)batchAnalyzeEPTagUsages.task.run.1.1.INSTANCE)) {
                                        StringBuilder stringBuilder = new StringBuilder().append("Skipping EP with no extensions in plugins: ");
                                        ExtensionPoint extensionPoint4 = this.$extensionPoint$inlined;
                                        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint4, (String)"extensionPoint");
                                        String string = stringBuilder.append(extensionPoint4.getEffectiveQualifiedName()).toString();
                                        boolean bl2 = false;
                                        System.out.println((Object)string);
                                    } else {
                                        ExtensionPoint extensionPoint5 = this.$extensionPoint$inlined;
                                        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint5, (String)"extensionPoint");
                                        PsiClass psiClass = extensionPoint5.getEffectiveClass();
                                        if (psiClass == null) {
                                        } else {
                                            PsiField epField;
                                            PsiClass effectiveClass;
                                            block14: {
                                                PsiField psiField;
                                                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"extensionPoint.effective\u2026s ?: return@runReadAction");
                                                effectiveClass = psiClass;
                                                PsiField[] psiFieldArray = effectiveClass.getFields();
                                                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"effectiveClass.fields");
                                                PsiField[] psiFieldArray2 = psiFieldArray;
                                                boolean bl3 = false;
                                                PsiField[] psiFieldArray3 = psiFieldArray2;
                                                boolean bl4 = false;
                                                PsiField[] psiFieldArray4 = psiFieldArray3;
                                                int n = psiFieldArray4.length;
                                                for (int i = 0; i < n; ++i) {
                                                    PsiField psiField2;
                                                    PsiField it = psiField2 = psiFieldArray4[i];
                                                    boolean bl5 = false;
                                                    if (!ExtensionPointUsageAnalyzerKt.access$isEPField(it)) continue;
                                                    psiField = psiField2;
                                                    break block14;
                                                }
                                                psiField = epField = null;
                                            }
                                            if (epField == null) {
                                                List list = this.this$0.$allUnsafeUsages;
                                                PsiElement psiElement = (PsiElement)effectiveClass;
                                                String string = DevKitBundle.message("extension.point.analyzer.reason.no.ep.field", new Object[0]);
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026yzer.reason.no.ep.field\")");
                                                list.add(new EPElementUsage(psiElement, string));
                                            } else {
                                                Project project = this.this$0.$file.getProject();
                                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                                                ExtensionPoint extensionPoint6 = this.$extensionPoint$inlined;
                                                Intrinsics.checkNotNullExpressionValue((Object)extensionPoint6, (String)"extensionPoint");
                                                LeakSearchContext context = new LeakSearchContext(project, extensionPoint6.getEffectiveQualifiedName(), this.this$0.$ignoreSafeClasses);
                                                context.processEPFieldUsages((PsiElement)epField);
                                                Iterable<E> iterable = context.getSafeUsages();
                                                boolean bl6 = false;
                                                if (!iterable.isEmpty() && context.getUnsafeUsages().isEmpty()) {
                                                    List list = this.this$0.$safeEPs;
                                                    ExtensionPoint extensionPoint7 = this.$extensionPoint$inlined;
                                                    Intrinsics.checkNotNullExpressionValue((Object)extensionPoint7, (String)"extensionPoint");
                                                    list.add(extensionPoint7);
                                                } else {
                                                    void $this$mapTo$iv;
                                                    iterable = context.getUnsafeUsages();
                                                    Collection destination$iv = this.this$0.$allUnsafeUsages;
                                                    boolean $i$f$mapTo = false;
                                                    for (E item$iv : $this$mapTo$iv) {
                                                        void it;
                                                        Pair pair = (Pair)item$iv;
                                                        Collection collection = destination$iv;
                                                        boolean bl7 = false;
                                                        PsiElement psiElement = ((Leak)it.getSecond()).getTargetElement();
                                                        if (psiElement == null) {
                                                            PsiElement psiElement2 = ((PsiReference)it.getFirst()).getElement();
                                                            psiElement = psiElement2;
                                                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.first.element");
                                                        }
                                                        EPElementUsage ePElementUsage = new EPElementUsage(psiElement, ((Leak)it.getSecond()).getReason());
                                                        collection.add(ePElementUsage);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ batchAnalyzeEPTagUsages.task.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        Project project = this.this$0.$file.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                        String string = DevKitBundle.message("extension.point.analyzer.usage.safe.eps", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026analyzer.usage.safe.eps\")");
                        Iterable iterable = this.this$0.$safeEPs;
                        UsageTarget usageTarget = new DummyUsageTarget(string);
                        Project project2 = project;
                        boolean $i$f$mapNotNull = false;
                        void var3_5 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        XmlElement xmlElement = $this$forEach$iv$iv$iv.iterator();
                        while (xmlElement.hasNext()) {
                            XmlElement xmlElement2;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = xmlElement.next();
                            boolean bl = false;
                            ExtensionPoint it = (ExtensionPoint)element$iv$iv;
                            boolean bl2 = false;
                            if (it.getXmlElement() == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            XmlElement it$iv$iv = xmlElement2;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Collection<EPElementUsage> collection = (List)destination$iv$iv;
                        $this$mapNotNull$iv = collection;
                        boolean $i$f$map = false;
                        $this$mapNotNullTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            xmlElement = (XmlElement)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            void v2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                            EPElementUsage ePElementUsage = new EPElementUsage((PsiElement)v2, null, 2, null);
                            collection.add(ePElementUsage);
                        }
                        collection = (List)destination$iv$iv;
                        ExtensionPointUsageAnalyzerKt.access$showEPElementUsages(project2, usageTarget, (List)collection);
                        Project project3 = this.this$0.$file.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
                        String string2 = DevKitBundle.message("extension.point.analyzer.usage.unsafe.eps", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"ex\u2026alyzer.usage.unsafe.eps\")");
                        ExtensionPointUsageAnalyzerKt.access$showEPElementUsages(project3, new DummyUsageTarget(string2), this.this$0.$allUnsafeUsages);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$domElement = $captured_local_variable$0;
                this.$allUnsafeUsages = $captured_local_variable$1;
                this.$file = $captured_local_variable$2;
                this.$ignoreSafeClasses = $captured_local_variable$3;
                this.$safeEPs = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInPluginModule(PsiElement element) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtil.findModuleFor\u2026(element) ?: return false");
        Module module2 = module;
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        if (StringsKt.startsWith$default((String)string, (String)"intellij.platform", (boolean)false, (int)2, null)) return false;
        String string2 = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
        if (StringsKt.startsWith$default((String)string2, (String)"intellij.clion", (boolean)false, (int)2, null)) return false;
        String string3 = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"module.name");
        if (StringsKt.startsWith$default((String)string3, (String)"intellij.appcode", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final /* synthetic */ QualifiedCall access$findQualifiedCall(UElement element) {
        return ExtensionPointUsageAnalyzerKt.findQualifiedCall(element);
    }

    public static final /* synthetic */ void access$analyze(PsiElement elementAtCaret, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        ExtensionPointUsageAnalyzerKt.analyze(elementAtCaret, file, editor, ignoreSafeClasses);
    }

    public static final /* synthetic */ void access$showEPElementUsages(Project project, UsageTarget usageTarget, List usages) {
        ExtensionPointUsageAnalyzerKt.showEPElementUsages(project, usageTarget, usages);
    }

    public static final /* synthetic */ boolean access$isInPluginModule(PsiElement element) {
        return ExtensionPointUsageAnalyzerKt.isInPluginModule(element);
    }

    public static final /* synthetic */ boolean access$isEPField(PsiField field) {
        return ExtensionPointUsageAnalyzerKt.isEPField(field);
    }
}

